/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands;

import io.github.nucleuspowered.nucleus.api.module.warp.NucleusWarpService;
import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.modules.warp.commands.WarpCommand;
import io.github.nucleuspowered.nucleus.modules.warp.event.DeleteWarpEvent;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"delwarp", "remwarp", "rmwarp"})
@NonnullByDefault
@Command(aliases={"delete", "del", "#delwarp", "#remwarp", "#rmwarp"}, basePermission={"nucleus.warp.delete.base"}, commandDescriptionKey="warp.list", async=true, parentCommand=WarpCommand.class)
public class DeleteWarpCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.getServiceUnchecked(WarpService.class).warpElement(false)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Warp warp = context.requireOne("warp", Warp.class);
        NucleusWarpService qs = (NucleusWarpService)Sponge.getServiceManager().provideUnchecked(NucleusWarpService.class);
        Cause cause = context.getCause().root() == context.getCommandSource() ? context.getCause() : context.getCause().with((Object)context.getCommandSource());
        DeleteWarpEvent event = new DeleteWarpEvent(cause, warp);
        if (Sponge.getEventManager().post((Event)event)) {
            return event.getCancelMessage().map(context::errorResultLiteral).orElseGet(() -> context.errorResult("nucleus.eventcancelled", new Object[0]));
        }
        if (qs.removeWarp(warp.getName())) {
            context.sendMessage("command.warps.del", warp.getName());
            return context.successResult();
        }
        return context.errorResult("command.warps.delerror", new Object[0]);
    }
}

