/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.RegexArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"getfromip"}, basePermission={"nucleus.getfromip.base"}, commandDescriptionKey="getfromip", async=true)
public class GetFromIpCommand
implements ICommandExecutor<CommandSource> {
    private final String ipKey = "IP Address";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{new RegexArgument((Text)Text.of((String)this.ipKey), "^(\\d{1,3}\\.){3}\\d{1,3}$", "command.getfromip.notvalid", serviceCollection)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        String ip = context.requireOne(this.ipKey, String.class);
        if (Arrays.stream(ip.split("\\.")).anyMatch(x -> Integer.parseInt(x) > 255)) {
            return context.errorResult("command.getfromip.notvalid", new Object[0]);
        }
        UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
        List users = context.getServiceCollection().userCacheService().getForIp(ip).stream().map(arg_0 -> ((UserStorageService)uss).get(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (users.isEmpty()) {
            context.sendMessage("command.getfromip.nousers", new Object[0]);
            return context.successResult();
        }
        Util.getPaginationBuilder(context.getCommandSource()).title(context.getMessage("command.getfromip.title", ip)).contents((Iterable)users.stream().map(y -> {
            Text n = context.getDisplayName(y.getUniqueId());
            return n.toBuilder().onClick((ClickAction)TextActions.runCommand((String)("/nucleus:seen " + y.getName()))).onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.getfromip.hover", n))).build();
        }).collect(Collectors.toList())).sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }
}

