/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nameban.commands;

import io.github.nucleuspowered.nucleus.api.module.nameban.exception.NameBanException;
import io.github.nucleuspowered.nucleus.modules.nameban.services.NameBanHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.RegexArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"nameunban", "namepardon"}, basePermission={"nucleus.nameban.unban.base"}, commandDescriptionKey="nameunban")
public class NameUnbanCommand
implements ICommandExecutor<CommandSource> {
    private final String nameKey = "name";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{new RegexArgument((Text)Text.of((String)this.nameKey), "[0-9a-zA-Z_]{3,16}", "command.nameban.notvalid", serviceCollection)};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        String name = context.requireOne(this.nameKey, String.class).toLowerCase();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)context.getCommandSource());
            context.getServiceCollection().getServiceUnchecked(NameBanHandler.class).removeName(name, frame.getCurrentCause());
            context.sendMessage("command.nameban.pardon.success", name);
            ICommandResult iCommandResult = context.successResult();
            return iCommandResult;
        }
        catch (NameBanException ex) {
            ex.printStackTrace();
            return context.errorResult("command.nameban.pardon.failed", name);
        }
    }
}

