/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.message.NucleusPrivateMessagingService;
import io.github.nucleuspowered.nucleus.modules.message.config.MessageConfig;
import io.github.nucleuspowered.nucleus.modules.message.events.InternalNucleusMessageEvent;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.scaffold.service.annotations.APIService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.texttemplatefactory.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTextTemplateFactory;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerDisplayNameService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserPreferenceService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@APIService(value=NucleusPrivateMessagingService.class)
public class MessageHandler
implements NucleusPrivateMessagingService,
IReloadableService.Reloadable,
ServiceBase {
    private MessageConfig messageConfig;
    private boolean useLevels = false;
    private boolean sameLevel = false;
    private int serverLevel = 0;
    private final INucleusServiceCollection serviceCollection;
    private final Map<UUID, UUID> messagesReceived = Maps.newHashMap();
    private final Map<UUID, CustomMessageTarget<? extends CommandSource>> targets = Maps.newHashMap();
    private final Map<String, UUID> targetNames = Maps.newHashMap();

    @Inject
    public MessageHandler(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
        this.onReload(serviceCollection);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.messageConfig = serviceCollection.moduleDataProvider().getModuleConfig(MessageConfig.class);
        this.useLevels = this.messageConfig.isSocialSpyLevels();
        this.sameLevel = this.messageConfig.isSocialSpySameLevel();
        this.serverLevel = this.messageConfig.getServerLevel();
    }

    @Override
    public boolean isSocialSpy(User user) {
        Tristate ts = this.forcedSocialSpyState(user);
        if (ts == Tristate.UNDEFINED) {
            return this.serviceCollection.userPreferenceService().getUnwrapped(user.getUniqueId(), NucleusKeysProvider.SOCIAL_SPY);
        }
        return ts.asBoolean();
    }

    @Override
    public boolean isUsingSocialSpyLevels() {
        return this.useLevels;
    }

    @Override
    public boolean canSpySameLevel() {
        return this.sameLevel;
    }

    @Override
    public int getCustomTargetLevel() {
        return this.messageConfig.getCustomTargetLevel();
    }

    @Override
    public int getServerLevel() {
        return this.serverLevel;
    }

    @Override
    public int getSocialSpyLevel(User user) {
        return this.useLevels ? this.serviceCollection.permissionService().getPositiveIntOptionFromSubject((Subject)user, "nucleus.socialspy.level").orElse(0) : 0;
    }

    @Override
    public Tristate forcedSocialSpyState(User user) {
        IPermissionService permissionService = this.serviceCollection.permissionService();
        if (permissionService.hasPermission((Subject)user, "nucleus.socialspy.base")) {
            if (this.messageConfig.isSocialSpyAllowForced() && permissionService.hasPermission((Subject)user, "nucleus.socialspy.force")) {
                return Tristate.TRUE;
            }
            return Tristate.UNDEFINED;
        }
        return Tristate.FALSE;
    }

    @Override
    public boolean setSocialSpy(User user, boolean isSocialSpy) {
        if (this.forcedSocialSpyState(user) != Tristate.UNDEFINED) {
            return false;
        }
        this.serviceCollection.userPreferenceService().set(user.getUniqueId(), NucleusKeysProvider.SOCIAL_SPY, Boolean.valueOf(isSocialSpy));
        return true;
    }

    @Override
    public boolean canSpyOn(User spyingUser, CommandSource ... sourceToSpyOn) throws IllegalArgumentException {
        if (sourceToSpyOn.length == 0) {
            throw new IllegalArgumentException("sourceToSpyOn must have at least one CommandSource");
        }
        if (this.isSocialSpy(spyingUser)) {
            if (Arrays.stream(sourceToSpyOn).anyMatch(x -> x instanceof User && spyingUser.getUniqueId().equals(((User)x).getUniqueId()))) {
                return false;
            }
            if (this.useLevels) {
                int target = Arrays.stream(sourceToSpyOn).mapToInt(this::getSocialSpyLevelForSource).max().orElse(0);
                if (this.sameLevel) {
                    return target <= this.getSocialSpyLevel(spyingUser);
                }
                return target < this.getSocialSpyLevel(spyingUser);
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<CommandSource> onlinePlayersCanSpyOn(boolean includeConsole, CommandSource ... sourceToSpyOn) throws IllegalArgumentException {
        if (sourceToSpyOn.length == 0) {
            throw new IllegalArgumentException("sourceToSpyOn must have at least one CommandSource");
        }
        List<CommandSource> toSpyOn = Arrays.asList(sourceToSpyOn);
        Set uuidsToSpyOn = toSpyOn.stream().map(x -> x instanceof User ? ((User)x).getUniqueId() : Util.CONSOLE_FAKE_UUID).collect(Collectors.toSet());
        Set<Object> sources = Sponge.getServer().getOnlinePlayers().stream().filter(x -> !uuidsToSpyOn.contains(x.getUniqueId())).filter(this::isSocialSpy).collect(Collectors.toSet());
        if (!this.useLevels) {
            if (includeConsole) {
                sources.add((CommandSource)Sponge.getServer().getConsole());
            }
            return sources;
        }
        int highestLevel = toSpyOn.stream().mapToInt(this::getSocialSpyLevelForSource).max().orElse(0);
        sources = sources.stream().filter(x -> this.sameLevel ? this.getSocialSpyLevelForSource((CommandSource)x) >= highestLevel : this.getSocialSpyLevelForSource((CommandSource)x) > highestLevel).collect(Collectors.toSet());
        if (includeConsole) {
            sources.add((CommandSource)Sponge.getServer().getConsole());
        }
        return sources;
    }

    @Override
    public boolean sendMessage(CommandSource sender, CommandSource receiver, String message) {
        Set<CommandSource> lm;
        MessageChannel mc;
        boolean isBlocked = false;
        boolean isCancelled = Sponge.getEventManager().post((Event)new InternalNucleusMessageEvent(sender, receiver, message));
        if (isCancelled) {
            this.serviceCollection.messageProvider().sendMessageTo(sender, "message.cancel");
            if (!this.messageConfig.isShowMessagesInSocialSpyWhileMuted()) {
                return false;
            }
        }
        IUserPreferenceService userPreferenceService = this.serviceCollection.userPreferenceService();
        if (receiver instanceof Player && !this.serviceCollection.permissionService().hasPermission((Subject)sender, "nucleus.msgtoggle.bypass") && !userPreferenceService.getUnwrapped(((Player)receiver).getUniqueId(), NucleusKeysProvider.RECEIVING_MESSAGES).booleanValue()) {
            isCancelled = true;
            isBlocked = true;
            this.serviceCollection.messageProvider().sendMessageTo(sender, "message.blocked", this.serviceCollection.playerDisplayNameService().getDisplayName(receiver));
            if (!this.messageConfig.isShowMessagesInSocialSpyWhileMuted()) {
                return false;
            }
        }
        UUID uuidSender = this.getUUID(sender);
        UUID uuidReceiver = this.getUUID(receiver);
        HashMap variables = Maps.newHashMap();
        variables.put("from", sender);
        variables.put("to", receiver);
        HashMap tokens = Maps.newHashMap();
        IPlayerDisplayNameService displayNameService = this.serviceCollection.playerDisplayNameService();
        tokens.put("from", cs -> this.getNameFromCommandSource(sender, displayNameService::getName));
        tokens.put("to", cs -> this.getNameFromCommandSource(receiver, displayNameService::getName));
        tokens.put("fromdisplay", cs -> this.getNameFromCommandSource(sender, displayNameService::getDisplayName));
        tokens.put("todisplay", cs -> this.getNameFromCommandSource(receiver, displayNameService::getDisplayName));
        Text tm = this.useMessage(sender, message);
        INucleusTextTemplateFactory textTemplateFactory = this.serviceCollection.textTemplateFactory();
        if (!isCancelled) {
            sender.sendMessage(this.constructMessage(sender, tm, this.messageConfig.getMessageSenderPrefix(textTemplateFactory), tokens, variables));
            receiver.sendMessage(this.constructMessage(sender, tm, this.messageConfig.getMessageReceiverPrefix(textTemplateFactory), tokens, variables));
        }
        NucleusTextTemplateImpl prefix = this.messageConfig.getMessageSocialSpyPrefix(textTemplateFactory);
        if (isBlocked) {
            prefix = textTemplateFactory.createFromAmpersandString(this.messageConfig.getBlockedTag() + prefix.getRepresentation());
        }
        if (isCancelled) {
            prefix = textTemplateFactory.createFromAmpersandString(this.messageConfig.getMutedTag() + prefix.getRepresentation());
        }
        MessageConfig.Targets targets = this.messageConfig.spyOn();
        if ((sender instanceof Player && targets.isPlayer() || sender instanceof ConsoleSource && targets.isCustom() || targets.isCustom()) && !(mc = MessageChannel.fixed(lm = this.onlinePlayersCanSpyOn(!uuidSender.equals(Util.CONSOLE_FAKE_UUID) && !uuidReceiver.equals(Util.CONSOLE_FAKE_UUID), sender, receiver))).getMembers().isEmpty()) {
            mc.send(this.constructMessage(sender, tm, prefix, tokens, variables));
        }
        if (!isCancelled) {
            this.messagesReceived.put(uuidReceiver, uuidSender);
        }
        return !isCancelled;
    }

    private Optional<Text> getNameFromCommandSource(CommandSource source, Function<CommandSource, Text> standardFn) {
        CustomMessageTarget<? extends CommandSource> target;
        if (source instanceof Identifiable && (target = this.targets.get(((Identifiable)source).getUniqueId())) != null) {
            return Optional.of(((CustomMessageTarget)target).getDisplayName());
        }
        return Optional.of(standardFn.apply(source));
    }

    public boolean replyMessage(CommandSource sender, String message) {
        Optional<CommandSource> cs = this.getLastMessageFrom(this.getUUID(sender));
        if (cs.isPresent()) {
            return this.sendMessage(sender, cs.get(), message);
        }
        this.serviceCollection.messageProvider().sendMessageTo(sender, "message.noreply");
        return false;
    }

    @Override
    public Optional<CommandSource> getConsoleReplyTo() {
        return this.getLastMessageFrom(Util.CONSOLE_FAKE_UUID);
    }

    @Override
    public Optional<CommandSource> getReplyTo(User user) {
        return this.getLastMessageFrom(user.getUniqueId());
    }

    @Override
    public <T extends CommandSource & Identifiable> Optional<CommandSource> getCommandSourceReplyTo(T from) {
        return this.getLastMessageFrom(((Identifiable)from).getUniqueId());
    }

    @Override
    public void setReplyTo(User user, CommandSource toReplyTo) {
        this.messagesReceived.put(user.getUniqueId(), this.getUUID((CommandSource)Preconditions.checkNotNull((Object)toReplyTo)));
    }

    @Override
    public void setConsoleReplyTo(CommandSource toReplyTo) {
        this.messagesReceived.put(Util.CONSOLE_FAKE_UUID, this.getUUID((CommandSource)Preconditions.checkNotNull((Object)toReplyTo)));
    }

    @Override
    public <T extends CommandSource & Identifiable> void setCommandSourceReplyTo(T source, CommandSource replyTo) {
        this.messagesReceived.put(((Identifiable)source).getUniqueId(), this.getUUID(replyTo));
    }

    @Override
    public void clearReplyTo(User user) {
        this.messagesReceived.remove(user.getUniqueId());
    }

    @Override
    public <T extends CommandSource & Identifiable> void clearCommandSourceReplyTo(T user) {
        this.messagesReceived.remove(((Identifiable)user).getUniqueId());
    }

    @Override
    public void clearConsoleReplyTo() {
        this.messagesReceived.remove(Util.CONSOLE_FAKE_UUID);
    }

    @Override
    public <T extends CommandSource & Identifiable> void registerMessageTarget(UUID uniqueId, String targetName, @Nullable Text displayName, Supplier<T> target) {
        Preconditions.checkNotNull((Object)uniqueId);
        Preconditions.checkNotNull((Object)targetName);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument((!uniqueId.equals(Util.CONSOLE_FAKE_UUID) ? 1 : 0) != 0, (Object)"Cannot use the zero UUID");
        Preconditions.checkArgument((boolean)targetName.toLowerCase().matches("[a-z0-9_-]{3,}"), (Object)"Target name must only contain letters, numbers, hyphens and underscores. and must be at least three characters long.");
        Preconditions.checkState((!this.targets.containsKey(uniqueId) ? 1 : 0) != 0, (Object)"UUID already registered");
        Preconditions.checkState((!this.targetNames.containsKey(targetName.toLowerCase()) ? 1 : 0) != 0, (Object)"Target name already registered.");
        this.targets.put(uniqueId, new CustomMessageTarget(uniqueId, displayName, target));
        this.targetNames.put(targetName.toLowerCase(), uniqueId);
    }

    private Optional<CommandSource> getLastMessageFrom(UUID from) {
        Optional om;
        Preconditions.checkNotNull((Object)from);
        UUID to = this.messagesReceived.get(from);
        if (to == null) {
            return Optional.empty();
        }
        if (to.equals(Util.CONSOLE_FAKE_UUID)) {
            return Optional.of(Sponge.getServer().getConsole());
        }
        if (this.targets.containsKey(to) && (om = ((CustomMessageTarget)this.targets.get(to)).get()).isPresent()) {
            return om.map(x -> x);
        }
        return Sponge.getServer().getOnlinePlayers().stream().filter(x -> x.getUniqueId().equals(to)).map(y -> y).findFirst();
    }

    public Optional<CommandSource> getTarget(String target) {
        CustomMessageTarget<? extends CommandSource> cmt;
        UUID u = this.targetNames.get(target.toLowerCase());
        if (u != null && (cmt = this.targets.get(u)) != null) {
            return ((CustomMessageTarget)cmt).get().map(x -> x);
        }
        return Optional.empty();
    }

    public ImmutableMap<String, UUID> getTargetNames() {
        return ImmutableMap.copyOf(this.targetNames);
    }

    private UUID getUUID(CommandSource sender) {
        return sender instanceof Identifiable ? ((Identifiable)sender).getUniqueId() : Util.CONSOLE_FAKE_UUID;
    }

    private Text constructMessage(CommandSource sender, Text message, NucleusTextTemplateImpl template, Map<String, Function<CommandSource, Optional<Text>>> tokens, Map<String, Object> variables) {
        return this.serviceCollection.textStyleService().joinTextsWithColoursFlowing(template.getForCommandSource(sender, tokens), message);
    }

    private Text useMessage(CommandSource player, String m) {
        this.serviceCollection.textStyleService().stripPermissionless("nucleus.message.colour", "nucleus.message.style", (Subject)player, m);
        Text result = this.serviceCollection.permissionService().hasPermission((Subject)player, "nucleus.message.url") ? this.serviceCollection.textStyleService().addUrls(m) : TextSerializers.FORMATTING_CODE.deserialize(m);
        return result;
    }

    private int getSocialSpyLevelForSource(CommandSource source) {
        if (this.useLevels) {
            if (source instanceof User) {
                return this.getSocialSpyLevel((User)source);
            }
            if (source instanceof Identifiable && this.targets.containsKey(((Identifiable)source).getUniqueId())) {
                return this.messageConfig.getCustomTargetLevel();
            }
            return this.messageConfig.getServerLevel();
        }
        return 0;
    }

    @NonnullByDefault
    private static class CustomMessageTarget<T extends CommandSource & Identifiable>
    implements Identifiable {
        private final UUID uuid;
        @Nullable
        private final Text displayName;
        private final Supplier<T> supplier;

        private CustomMessageTarget(UUID uuid, @Nullable Text displayName, Supplier<T> supplier) {
            this.uuid = uuid;
            this.displayName = displayName;
            this.supplier = supplier;
        }

        private Optional<T> get() {
            CommandSource t = (CommandSource)this.supplier.get();
            if (((Identifiable)t).getUniqueId().equals(this.uuid)) {
                return Optional.of(t);
            }
            return Optional.empty();
        }

        private Text getDisplayName() {
            return this.displayName == null ? Text.of((String)((CommandSource)this.supplier.get()).getName()) : this.displayName;
        }

        public UUID getUniqueId() {
            return this.uuid;
        }
    }
}

