/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.serialiser;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.configurate.wrappers.NucleusItemStackSnapshot;
import io.github.nucleuspowered.nucleus.modules.kit.misc.SingleKit;
import io.github.nucleuspowered.nucleus.util.TypeTokens;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.plugin.PluginContainer;

public class SingleKitTypeSerilaiser {
    public static final SingleKitTypeSerilaiser INSTANCE = new SingleKitTypeSerilaiser();
    private static final String STACKS = "stacks";
    private static final String INTERVAL = "interval";
    private static final String COST = "cost";
    private static final String AUTO_REDEEM = "autoRedeem";
    private static final String ONE_TIME = "oneTime";
    private static final String DISPLAY_MESSAGE = "displayMessage";
    private static final String IGNORES_PERMISSION = "ignoresPermission";
    private static final String HIDDEN = "hidden";
    private static final String COMMANDS = "commands";
    private static final String FIRST_JOIN = "firstJoin";

    private SingleKitTypeSerilaiser() {
    }

    public Map<String, Kit> deserialize(@NonNull ConfigurationNode value) throws ObjectMappingException {
        HashMap<String, Kit> kits;
        block6: {
            ConfigurationNode node;
            kits = new HashMap<String, Kit>();
            if (value.getChildrenMap().size() == 1 && (node = (ConfigurationNode)value.getChildrenMap().get("kits")) != null) {
                try {
                    kits.putAll(this.deserialize(node));
                    ((PluginContainer)Sponge.getPluginManager().getPlugin("nucleus").get()).getLogger().info("Migrated v1 kits to v2.");
                    value.getNode(new Object[]{"kits"}).setValue(null);
                    this.serialize(kits, value);
                    return kits;
                }
                catch (Exception exception) {
                    if (!node.getChildrenMap().isEmpty() || !node.getChildrenList().isEmpty()) break block6;
                    value.getNode(new Object[]{"kits"}).setValue(null);
                }
            }
        }
        for (Map.Entry entry : value.getChildrenMap().entrySet()) {
            String kitName = entry.getKey().toString().toLowerCase();
            ConfigurationNode node = (ConfigurationNode)entry.getValue();
            if (node.isVirtual()) continue;
            if (node.getNode(new Object[]{INTERVAL}).isVirtual()) {
                if (kitName.equals("kits")) {
                    ((PluginContainer)Sponge.getPluginManager().getPlugin("nucleus").get()).getLogger().warn("v1 kits entry detected. It will be ignored.");
                    continue;
                }
                throw new IllegalStateException("Kits file is malformed");
            }
            List<ItemStackSnapshot> itemStackSnapshots = node.getNode(new Object[]{STACKS}).getList(TypeToken.of(NucleusItemStackSnapshot.class)).stream().map(NucleusItemStackSnapshot::getSnapshot).map(ValueContainer::copy).collect(Collectors.toList());
            long interval = node.getNode(new Object[]{INTERVAL}).getLong(0L);
            double cost = node.getNode(new Object[]{COST}).getDouble(0.0);
            boolean autoRedeem = node.getNode(new Object[]{AUTO_REDEEM}).getBoolean(false);
            boolean oneTime = node.getNode(new Object[]{ONE_TIME}).getBoolean(false);
            boolean displayMessage = node.getNode(new Object[]{DISPLAY_MESSAGE}).getBoolean(true);
            boolean ignoresPermission = node.getNode(new Object[]{IGNORES_PERMISSION}).getBoolean(false);
            boolean hidden = node.getNode(new Object[]{HIDDEN}).getBoolean(false);
            List commands = node.getNode(new Object[]{COMMANDS}).getList(TypeTokens.STRING);
            boolean firstJoin = node.getNode(new Object[]{FIRST_JOIN}).getBoolean(false);
            SingleKit k = new SingleKit(kitName, itemStackSnapshots, Duration.ofSeconds(interval), cost, autoRedeem, oneTime, displayMessage, ignoresPermission, hidden, commands, firstJoin);
            kits.put(kitName, k);
        }
        return kits;
    }

    public void serialize(@Nullable Map<String, Kit> obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        if (obj != null) {
            for (Map.Entry<String, Kit> entry : obj.entrySet()) {
                Kit kit = entry.getValue();
                ConfigurationNode node = value.getNode(new Object[]{entry.getKey().toLowerCase()});
                node.getNode(new Object[]{STACKS}).setValue((TypeToken)new TypeToken<List<NucleusItemStackSnapshot>>(){}, kit.getStacks().stream().map(NucleusItemStackSnapshot::new).collect(Collectors.toList()));
                node.getNode(new Object[]{INTERVAL}).setValue((Object)kit.getCooldown().map(Duration::getSeconds).orElse(0L));
                node.getNode(new Object[]{COST}).setValue((Object)kit.getCost());
                node.getNode(new Object[]{AUTO_REDEEM}).setValue((Object)kit.isAutoRedeem());
                node.getNode(new Object[]{ONE_TIME}).setValue((Object)kit.isOneTime());
                node.getNode(new Object[]{DISPLAY_MESSAGE}).setValue((Object)kit.isDisplayMessageOnRedeem());
                node.getNode(new Object[]{IGNORES_PERMISSION}).setValue((Object)kit.ignoresPermission());
                node.getNode(new Object[]{HIDDEN}).setValue((Object)kit.isHiddenFromList());
                node.getNode(new Object[]{COMMANDS}).setValue((TypeToken)new TypeToken<List<String>>(){}, kit.getCommands());
                node.getNode(new Object[]{FIRST_JOIN}).setValue((Object)kit.isFirstJoinKit());
            }
        }
    }
}

