/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.experience.commands;

import io.github.nucleuspowered.nucleus.modules.experience.commands.ExperienceCommand;
import io.github.nucleuspowered.nucleus.modules.experience.parameter.ExperienceLevelArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"set"}, parentCommand=ExperienceCommand.class, basePermission={"nucleus.exp.set.base"}, commandDescriptionKey="exp.set")
@NonnullByDefault
public class SetExperience
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_PLAYER.get(serviceCollection), GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.onlyOne((CommandElement)new ExperienceLevelArgument((Text)Text.of((String)"level"), serviceCollection)), GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)"experience"), serviceCollection))})};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.getPlayerFromArgs();
        Optional<ICommandResult> r = ExperienceCommand.checkGameMode(context, pl);
        if (r.isPresent()) {
            return r.get();
        }
        Optional<Integer> l = context.getOne("level", Integer.TYPE);
        DataTransactionResult dtr = l.map(integer -> pl.offer(Keys.EXPERIENCE_LEVEL, integer)).orElseGet(() -> pl.offer(Keys.TOTAL_EXPERIENCE, (Object)context.requireOne("experience", Integer.TYPE)));
        return ExperienceCommand.tellUserAboutExperience(context, pl, dtr.isSuccessful());
    }
}

