/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ban.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.configurate.config.CommonPermissionLevelConfig;
import io.github.nucleuspowered.nucleus.modules.ban.config.BanConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.ban.Ban;

@Command(aliases={"unban", "pardon"}, basePermission={"nucleus.tempban.base"}, commandDescriptionKey="unban", associatedPermissionLevelKeys={"nucleus.ban.level"})
@EssentialsEquivalent(value={"unban", "pardon"})
@NonnullByDefault
public class UnbanCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private CommonPermissionLevelConfig levelConfig = new CommonPermissionLevelConfig();

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{NucleusParameters.ONE_GAME_PROFILE_UUID.get(serviceCollection), NucleusParameters.ONE_GAME_PROFILE.get(serviceCollection)})};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        GameProfile gp = context.hasAny("user uuid") ? context.requireOne("user uuid", GameProfile.class) : context.requireOne("user", GameProfile.class);
        BanService service = (BanService)Sponge.getServiceManager().provideUnchecked(BanService.class);
        Optional obp = service.getBanFor(gp);
        if (!obp.isPresent()) {
            return context.errorResult("command.checkban.notset", Util.getNameOrUnkown(context, gp));
        }
        User user = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).getOrCreate(gp);
        if (this.levelConfig.isUseLevels() && !context.isPermissionLevelOkay((Subject)user, "nucleus.ban.level", "nucleus.unban.base", this.levelConfig.isCanAffectSameLevel())) {
            return context.errorResult("command.modifiers.level.insufficient", user.getName());
        }
        service.removeBan((Ban)obp.get());
        MutableMessageChannel notify = context.getServiceCollection().permissionService().permissionMessageChannel("nucleus.ban.notify").asMutable();
        notify.addMember((MessageReceiver)context.getCommandSource());
        for (MessageReceiver receiver : notify.getMembers()) {
            context.sendMessageTo(receiver, "command.unban.success", Util.getNameOrUnkown(context, ((Ban.Profile)obp.get()).getProfile()), context.getName());
        }
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.levelConfig = serviceCollection.moduleDataProvider().getModuleConfig(BanConfig.class).getLevelConfig();
    }
}

