/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.afk.infoprovider;

import io.github.nucleuspowered.nucleus.modules.afk.services.AFKHandler;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.playerinformation.NucleusProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.util.Optional;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;

public class AFKInfoProvider
implements NucleusProvider {
    @Override
    public String getCategory() {
        return "afk";
    }

    @Override
    public Optional<Text> get(User user, CommandSource source, INucleusServiceCollection serviceCollection) {
        if (serviceCollection.permissionService().hasPermission((Subject)source, "nucleus.afk.notify")) {
            AFKHandler handler = serviceCollection.getServiceUnchecked(AFKHandler.class);
            IMessageProviderService messageProviderService = serviceCollection.messageProvider();
            if (user.isOnline()) {
                Player player = (Player)user.getPlayer().get();
                String timeToNow = messageProviderService.getTimeToNow(source.getLocale(), handler.lastActivity(player));
                if (handler.canGoAFK((User)player)) {
                    if (handler.isAFK(player)) {
                        return Optional.of(messageProviderService.getMessageFor(source.getLocale(), "command.seen.afk", messageProviderService.getMessageFor(source.getLocale(), "standard.yesno.true"), timeToNow));
                    }
                    return Optional.of(messageProviderService.getMessageFor(source.getLocale(), "command.seen.afk", messageProviderService.getMessageFor(source.getLocale(), "standard.yesno.false"), timeToNow));
                }
                return Optional.of(messageProviderService.getMessageFor(source.getLocale(), "command.seen.afk", messageProviderService.getMessageFor(source.getLocale(), "standard.yesno.false"), timeToNow));
            }
        }
        return Optional.empty();
    }
}

