/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.region.Region;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.RegionEventType;
import com.universeguard.utils.RegionUtils;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagExpDropListener {
    @Listener
    public void onRespawn(RespawnPlayerEvent event, @First Player player) {
        Player OriginalPlayer = event.getOriginalPlayer();
        Region region = RegionUtils.getRegion((Location<World>)OriginalPlayer.getLocation());
        if (region != null && !region.getFlag(EnumRegionFlag.EXP_DROP)) {
            Optional OptionalLevel = OriginalPlayer.get(Keys.EXPERIENCE_LEVEL);
            Optional OptionalExp = OriginalPlayer.get(Keys.TOTAL_EXPERIENCE);
            if (OptionalLevel.isPresent() && OptionalExp.isPresent()) {
                player.offer(Keys.EXPERIENCE_LEVEL, OptionalLevel.get());
                player.offer(Keys.TOTAL_EXPERIENCE, OptionalExp.get());
            }
        }
    }

    @Listener
    public void onExpDrop(SpawnEntityEvent event) {
        Entity entity;
        EntityType type;
        if (!event.getEntities().isEmpty() && (type = (entity = (Entity)event.getEntities().get(0)).getType()).equals(EntityTypes.EXPERIENCE_ORB)) {
            RegionUtils.handleEvent((Cancellable)event, EnumRegionFlag.EXP_DROP, (Location<World>)entity.getLocation(), null, RegionEventType.GLOBAL);
        }
    }
}

