/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scoreboard.objective.Objective;

public class RegionDiscardExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (RegionUtils.hasPendingRegion(src)) {
            Player player;
            Region region = RegionUtils.getPendingRegion(src);
            if (src instanceof Player && (player = (Player)src).getScoreboard().getObjective("Region").isPresent()) {
                player.getScoreboard().removeObjective((Objective)player.getScoreboard().getObjective("Region").get());
            }
            RegionUtils.setPendingRegion(src, null);
            RegionUtils.reloadRegion(region.getId(), region.getType());
            MessageUtils.sendSuccessMessage(src, RegionText.REGION_DISCARDED.getValue());
        } else {
            MessageUtils.sendErrorMessage(src, RegionText.NO_PENDING_REGION.getValue());
        }
        return CommandResult.empty();
    }
}

