/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import mekanism.api.Coord4D;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

@SideOnly(value=Side.CLIENT)
public class GuiSeismicReader
extends GuiScreen {
    private ItemStack itemStack;
    private Coord4D pos;
    private int xSize = 137;
    private int ySize = 182;
    private World worldObj;
    private ArrayList<Pair<Integer, Block>> blockList = new ArrayList();
    private Rectangle upButton;
    private Rectangle downButton;
    private Rectangle tooltip;
    private int currentLayer;

    public GuiSeismicReader(World world, Coord4D coord, ItemStack stack) {
        this.pos = new Coord4D(coord.x, Math.min(255, coord.y), coord.z, world.field_73011_w.getDimension());
        this.worldObj = world;
        this.itemStack = stack;
        this.calculate();
        this.currentLayer = Math.max(0, this.blockList.size() - 1);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.upButton = new Rectangle((this.field_146294_l - this.xSize) / 2 + 70, (this.field_146295_m - this.ySize) / 2 + 75, 13, 13);
        this.downButton = new Rectangle((this.field_146294_l - this.xSize) / 2 + 70, (this.field_146295_m - this.ySize) / 2 + 92, 13, 13);
        this.tooltip = new Rectangle((this.field_146294_l - this.xSize) / 2 + 30, (this.field_146295_m - this.ySize) / 2 + 82, 16, 16);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.xSize) / 2;
        int guiHeight = (this.field_146295_m - this.ySize) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiSeismicReader.png"));
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.xSize, this.ySize);
        if (this.upButton.intersects((ReadableRectangle)new Rectangle(mouseX, mouseY, 1, 1))) {
            GL11.glColor3f((float)0.5f, (float)0.5f, (float)1.0f);
        }
        this.func_73729_b(this.upButton.getX(), this.upButton.getY(), 137, 0, this.upButton.getWidth(), this.upButton.getHeight());
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.downButton.intersects((ReadableRectangle)new Rectangle(mouseX, mouseY, 1, 1))) {
            GL11.glColor3f((float)0.5f, (float)0.5f, (float)1.0f);
        }
        this.func_73729_b(this.downButton.getX(), this.downButton.getY(), 150, 0, this.downButton.getWidth(), this.downButton.getHeight());
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(guiWidth + 48), (float)(guiHeight + 87), (float)0.0f);
        if (this.currentLayer >= 100) {
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        }
        this.field_146289_q.func_78276_b(String.format("%s", this.currentLayer), 0, 0, 0xAFAFAF);
        GlStateManager.func_179121_F();
        for (int i = 0; i < 9; ++i) {
            int centralX = guiWidth + 32;
            int centralY = guiHeight + 103;
            int layer = this.currentLayer + (i - 5);
            if (0 > layer || layer >= this.blockList.size()) continue;
            ItemStack stack = new ItemStack((Block)this.blockList.get(layer).getRight(), 1, ((Integer)this.blockList.get(layer).getLeft()).intValue());
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(centralX - 2), (float)(centralY - i * 16 + 44), (float)0.0f);
            if (i < 4) {
                GlStateManager.func_179109_b((float)0.2f, (float)2.5f, (float)0.0f);
            }
            if (i != 4) {
                GlStateManager.func_179109_b((float)1.5f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
            }
            RenderHelper.func_74520_c();
            this.field_146296_j.func_180450_b(stack, 0, 0);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
        if (this.currentLayer - 1 >= 0) {
            ItemStack nameStack = new ItemStack((Block)this.blockList.get(this.currentLayer - 1).getRight(), 1, ((Integer)this.blockList.get(this.currentLayer - 1).getLeft()).intValue());
            String renderString = nameStack.func_82833_r();
            String capitalised = renderString.substring(0, 1).toUpperCase() + renderString.substring(1);
            int lengthX = this.field_146289_q.func_78256_a(capitalised);
            float renderScale = lengthX > 53 ? 53.0f / (float)lengthX : 1.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(guiWidth + 72), (float)(guiHeight + 16), (float)0.0f);
            GlStateManager.func_179152_a((float)renderScale, (float)renderScale, (float)renderScale);
            this.field_146289_q.func_78276_b(capitalised, 0, 0, 0x919191);
            GlStateManager.func_179121_F();
            if (this.tooltip.intersects((ReadableRectangle)new Rectangle(mouseX, mouseY, 1, 1))) {
                this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiTooltips.png"));
                int fontLengthX = this.field_146289_q.func_78256_a(capitalised) + 5;
                int renderX = mouseX + 10;
                int renderY = mouseY - 5;
                GlStateManager.func_179094_E();
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(renderX, renderY, 0, 0, fontLengthX, 16);
                this.func_73729_b(renderX + fontLengthX, renderY, 0, 16, 2, 16);
                this.field_146289_q.func_78276_b(capitalised, renderX + 4, renderY + 4, 0x919191);
                GlStateManager.func_179121_F();
            }
        }
        int frequency = 0;
        for (Pair<Integer, Block> pair : this.blockList) {
            if (this.blockList.get(this.currentLayer - 1) == null) continue;
            Block block = (Block)this.blockList.get(this.currentLayer - 1).getRight();
            if (pair.getRight() != block || !Objects.equals(pair.getLeft(), this.blockList.get(this.currentLayer - 1).getLeft())) continue;
            ++frequency;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(guiWidth + 72), (float)(guiHeight + 26), (float)0.0f);
        GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.abundancy") + ": " + frequency, 0, 0, 0x919191);
        GlStateManager.func_179121_F();
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    public String wrapString(String str, int index) {
        String string = str;
        for (int i = 0; i < string.length(); ++i) {
            if (i != index) continue;
            string = string.substring(0, i) + "\n" + string.substring(i);
        }
        return string;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.blockList.clear();
    }

    public void calculate() {
        BlockPos p = new BlockPos(this.pos.x, 0, this.pos.z);
        while (p.func_177956_o() < this.pos.y) {
            IBlockState state = this.worldObj.func_180495_p(p);
            Block block = state.func_177230_c();
            int metadata = block.func_176201_c(state);
            this.blockList.add((Pair<Integer, Block>)Pair.of((Object)metadata, (Object)block));
            p = p.func_177984_a();
        }
    }

    protected void func_73864_a(int xPos, int yPos, int buttonClicked) throws IOException {
        super.func_73864_a(xPos, yPos, buttonClicked);
        if (this.upButton.intersects((ReadableRectangle)new Rectangle(xPos, yPos, 1, 1)) && this.currentLayer + 1 <= this.blockList.size() - 1) {
            ++this.currentLayer;
        }
        if (this.downButton.intersects((ReadableRectangle)new Rectangle(xPos, yPos, 1, 1)) && this.currentLayer - 1 >= 1) {
            --this.currentLayer;
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

