/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.network.messages;

import io.netty.buffer.ByteBuf;
import lumien.randomthings.client.particles.ParticleFlooFlame;
import lumien.randomthings.network.IRTMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageFlooToken
implements IRTMessage {
    int dimension;
    double posX;
    double posY;
    double posZ;

    public MessageFlooToken() {
    }

    public MessageFlooToken(int dimension, double posX, double posY, double posZ) {
        this.dimension = dimension;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage(MessageContext context) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            World world = player.field_70170_p;
            if (world.field_73011_w.getDimension() == this.dimension) {
                float modX = -1.0f;
                while (modX <= 1.0f) {
                    float modZ = -1.0f;
                    while (modZ <= 1.0f) {
                        ParticleFlooFlame particle = new ParticleFlooFlame(world, this.posX + (double)modX + (Math.random() * 0.1 - 0.05), this.posY - 1.0, this.posZ + (double)modZ + (Math.random() * 0.1 - 0.05), 0.0, Math.random() * 0.3 + 0.1, 0.0);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                        modZ = (float)((double)modZ + 0.05);
                    }
                    modX = (float)((double)modX + 0.05);
                }
            }
        }
    }

    @Override
    public Side getHandlingSide() {
        return Side.CLIENT;
    }
}

