/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.render;

import io.github.phantamanta44.libnine.util.format.TextFormatUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderUtils {
    @Nullable
    public static TextureAtlasSprite prepareRender(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill(fluidStack).toString());
        int colour = fluid.getColor(fluidStack);
        TextFormatUtils.setGlColour(colour, TextFormatUtils.getComponent(colour, 3));
        return sprite;
    }

    public static void renderFluidIntoGui(Tessellator tess, BufferBuilder buf, int x, int y, int width, int height, TextureAtlasSprite sprite, double fraction) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int fluidHeight = Math.round((float)height * (float)Math.min(1.0, Math.max(0.0, fraction)));
        double x2 = x + width;
        while (fluidHeight > 0) {
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            double y1 = y + height - fluidHeight;
            double y2 = y1 + (double)Math.min(fluidHeight, width);
            double u1 = sprite.func_94209_e();
            double v1 = sprite.func_94206_g();
            double u2 = sprite.func_94212_f();
            double v2 = sprite.func_94210_h();
            if (fluidHeight < width) {
                v2 = v1 + (v2 - v1) * ((double)fluidHeight / (double)width);
                fluidHeight = 0;
            } else {
                fluidHeight -= width;
            }
            buf.func_181662_b((double)x, y1, 0.0).func_187315_a(u1, v1).func_181675_d();
            buf.func_181662_b((double)x, y2, 0.0).func_187315_a(u1, v2).func_181675_d();
            buf.func_181662_b(x2, y2, 0.0).func_187315_a(u2, v2).func_181675_d();
            buf.func_181662_b(x2, y1, 0.0).func_187315_a(u2, v1).func_181675_d();
            tess.func_78381_a();
        }
    }

    public static void renderFluidIntoGui(Tessellator tess, BufferBuilder buf, int x, int y, int width, int height, @Nullable FluidStack fluidStack, int capacity) {
        TextureAtlasSprite sprite;
        if (fluidStack != null && fluidStack.amount > 0 && (sprite = FluidRenderUtils.prepareRender(fluidStack)) != null) {
            FluidRenderUtils.renderFluidIntoGui(tess, buf, x, y, width, height, sprite, Math.max((double)fluidStack.amount / (double)capacity, 1.0 / (double)height));
        }
    }

    public static void renderFluidIntoGuiCleanly(int x, int y, int width, int height, @Nullable FluidStack fluidStack, int capacity) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tess = Tessellator.func_178181_a();
        FluidRenderUtils.renderFluidIntoGui(tess, tess.func_178180_c(), x, y, width, height, fluidStack, capacity);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

