/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.core.client.gui.element;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.romvoid95.galactic.core.client.gui.element.GuiElement;

public class LabelElement
extends GuiElement {
    private final List<String> labels = Lists.newArrayList();
    private final int textColor;
    private boolean centered;
    private int backColor;
    private int ulColor;
    private int brColor;
    private int border;

    public LabelElement(int x, int y, int color) {
        super(x, y, 0, 0);
        this.textColor = color;
        this.setX(x);
        this.setY(y);
        this.visible = true;
    }

    public LabelElement(int x, int y) {
        this(x, y, -1);
    }

    public LabelElement(String text, int x, int y) {
        this(x, y);
        this.addLine(text);
    }

    @Override
    public void draw(int mouseX, int mouseY, float partial) {
        if (this.visible) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            int i = this.getY() + this.height / 2 + this.border / 2;
            int j = i - this.labels.size() * 10 / 2;
            for (int k = 0; k < this.labels.size(); ++k) {
                if (this.centered) {
                    this.func_73732_a(this.fontRenderer, this.labels.get(k), this.getX(), j + k * 10, this.textColor);
                    continue;
                }
                this.func_73731_b(this.fontRenderer, this.labels.get(k), this.getX(), j + k * 10, this.textColor);
            }
        }
    }

    public void addLine(String translateKey) {
        this.labels.add(I18n.func_135052_a((String)translateKey, (Object[])new Object[0]));
    }

    public void setText(String text) {
        this.labels.clear();
        this.labels.addAll(Arrays.asList(text.split("\n")));
    }

    public void setCentered() {
        this.centered = true;
    }

    @Override
    public void mouseClick(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }
}

