/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.api.world;

import net.minecraft.world.biome.Biome;

public class BiomeData
extends Biome.BiomeProperties {
    private String biomeName;
    private float baseHeight;
    private float heightVariation;
    private float temperature;

    private BiomeData(String name, float temperature, float rainfall, float baseHeight, float heightVariation, boolean enableRain, boolean enableSnow, int waterColor, String baseBiomeRegName) {
        super(name);
        this.func_185410_a(temperature);
        this.func_185395_b(rainfall);
        this.func_185398_c(baseHeight);
        this.func_185400_d(heightVariation);
        if (!enableRain) {
            this.func_185396_a();
        }
        if (enableSnow) {
            this.func_185411_b();
        }
        this.func_185402_a(waterColor);
        this.func_185399_a(baseBiomeRegName);
        this.biomeName = name;
        this.baseHeight = baseHeight;
        this.heightVariation = heightVariation;
        this.temperature = temperature;
    }

    protected String getBiomeName() {
        return this.biomeName;
    }

    protected float getBaseHeight() {
        return this.baseHeight;
    }

    protected float getHeightVariation() {
        return this.heightVariation;
    }

    protected float getTemperature() {
        return this.temperature;
    }

    public static class DataValues {
        private final String biomeName;
        private float baseHeight = 0.1f;
        private float heightVariation = 0.2f;
        private float temperature = 0.5f;
        private float rainfall = 0.0f;
        private int waterColor = 0xFFFFFF;
        private boolean enableSnow = true;
        private boolean enableRain = true;
        private String baseBiomeRegName;

        public DataValues(String name) {
            this.biomeName = name;
        }

        public DataValues temperature(Float temperature) {
            if (temperature != null) {
                this.temperature = temperature.floatValue();
            }
            return this;
        }

        public DataValues rainfall(Float rainfall) {
            if (rainfall != null) {
                this.rainfall = rainfall.floatValue();
            }
            return this;
        }

        public DataValues baseHeight(Float baseHeight) {
            if (baseHeight != null) {
                this.baseHeight = baseHeight.floatValue();
            }
            return this;
        }

        public DataValues heightVariation(Float heightVariation) {
            if (heightVariation != null) {
                this.heightVariation = heightVariation.floatValue();
            }
            return this;
        }

        public DataValues disableRain() {
            if (this.rainfall == 0.0f) {
                this.enableRain = false;
            }
            return this;
        }

        public DataValues disableSnow() {
            if (!this.enableRain) {
                this.enableSnow = false;
            }
            return this;
        }

        public DataValues waterColor(Integer waterColor) {
            if (waterColor != null) {
                this.waterColor = waterColor;
            }
            return this;
        }

        public DataValues baseBiome(String name) {
            if (name != null) {
                this.baseBiomeRegName = name;
            }
            return this;
        }

        public BiomeData finalzie() {
            return new BiomeData(this.biomeName, this.temperature, this.rainfall, this.baseHeight, this.heightVariation, this.enableRain, this.enableSnow, this.waterColor, this.baseBiomeRegName);
        }
    }
}

