/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.helpers;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import ic2.core.util.obj.IBlockStateLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.MapPopulator;
import net.minecraft.util.math.Cartesian;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStateContainerIC2
extends BlockStateContainer {
    private static final Function<IProperty<?>, String> GET_NAME_FUNC = new Function<IProperty<?>, String>(){

        public String apply(IProperty<?> p_apply_1_) {
            return p_apply_1_ == null ? "<NULL>" : p_apply_1_.func_177701_a();
        }
    };
    private Block block;
    private ImmutableSortedMap<String, IProperty<?>> properties = ImmutableSortedMap.of();
    private ImmutableList<IBlockState> validStates = ImmutableList.of();
    private ImmutableList<IBlockState> allStates = ImmutableList.of();

    public BlockStateContainerIC2(Block blockIn, IProperty<?> ... properties) {
        this(blockIn, properties, (ImmutableMap<IUnlistedProperty<?>, Optional<?>>)null);
    }

    public BlockStateContainerIC2(Block blockIn, IProperty<?>[] properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        super(blockIn, new IProperty[0], null);
        IBlockStateLoader loader = (IBlockStateLoader)blockIn;
        HashMap map = Maps.newHashMap();
        for (IProperty<?> iproperty : properties) {
            BlockStateContainerIC2.func_185919_a((Block)blockIn, iproperty);
            map.put(iproperty.func_177701_a(), iproperty);
        }
        this.properties = ImmutableSortedMap.copyOf((Map)map);
        LinkedHashMap map2 = Maps.newLinkedHashMap();
        ArrayList list1 = Lists.newArrayList();
        for (List list : Cartesian.func_179321_a(this.getAllowedValues())) {
            Map map1 = MapPopulator.func_179400_b((Iterable)this.properties.values(), (Iterable)list);
            BlockStateContainer.StateImplementation blockstatecontainer$stateimplementation = this.createState(blockIn, ImmutableMap.copyOf((Map)map1), unlistedProperties);
            map2.put(map1, blockstatecontainer$stateimplementation);
            list1.add(blockstatecontainer$stateimplementation);
        }
        for (BlockStateContainer.StateImplementation blockstatecontainer$stateimplementation1 : list1) {
            blockstatecontainer$stateimplementation1.func_177235_a((Map)map2);
        }
        this.allStates = ImmutableList.copyOf((Collection)list1);
        this.validStates = ImmutableList.copyOf(loader.getValidStates((IBlockState)this.allStates.get(0)));
    }

    protected BlockStateContainer.StateImplementation createState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, @Nullable ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        return new IC2State(block, properties);
    }

    public IBlockState func_177621_b() {
        return (IBlockState)this.validStates.get(0);
    }

    public ImmutableList<IBlockState> func_177619_a() {
        return this.validStates;
    }

    public ImmutableList<IBlockState> getAllStates() {
        return this.allStates;
    }

    public Block func_177622_c() {
        return this.block;
    }

    public Collection<IProperty<?>> func_177623_d() {
        return this.properties.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("block", Block.field_149771_c.func_177774_c((Object)this.block)).add("properties", (Object)Iterables.transform((Iterable)this.properties.values(), GET_NAME_FUNC)).toString();
    }

    public IProperty<?> func_185920_a(String propertyName) {
        return (IProperty)this.properties.get((Object)propertyName);
    }

    private List<Iterable<Comparable<?>>> getAllowedValues() {
        ArrayList list = Lists.newArrayList();
        for (IProperty iproperty : this.properties.values()) {
            list.add(iproperty.func_177700_c());
        }
        return list;
    }

    private static class IC2State
    extends BlockStateContainer.StateImplementation {
        protected IC2State(Block arg0, ImmutableMap<IProperty<?>, Comparable<?>> arg1) {
            super(arg0, arg1);
        }
    }

    public static class IC2BlockState
    extends BlockStateContainer.StateImplementation {
        public Object data;

        public IC2BlockState(IBlockState state, Object toInject) {
            super(state.func_177230_c(), state.func_177228_b(), ((BlockStateContainer.StateImplementation)state).getPropertyValueTable());
            this.data = toInject;
        }

        public <T> T getData() {
            return (T)this.data;
        }

        public <T> T getData(Class<T> clz) {
            return (T)this.data;
        }

        public int getAsInteger() {
            if (!(this.data instanceof Integer)) {
                return 0;
            }
            return (Integer)this.data;
        }
    }
}

