/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.player.achievements.criteria;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;

public abstract class IStatPredicate {
    public abstract boolean test(EntityPlayerMP var1);

    public static IStatPredicate createFromObject(JsonElement element) {
        if (element != null && element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            String type = obj.get("type").getAsString();
            if (type.equalsIgnoreCase("normal")) {
                int amount = obj.has("amount") ? obj.get("amount").getAsInt() : 0;
                return new NormalStat(obj.get("stat").getAsString(), amount);
            }
            if (type.equalsIgnoreCase("percent")) {
                int amount = obj.has("baseAmount") ? obj.get("baseAmount").getAsInt() : 100;
                return new PercentStat(obj.get("baseStat").getAsString(), obj.get("otherStat").getAsString(), amount, obj.get("percent").getAsInt());
            }
            throw new RuntimeException("Type has to be either normal or percent: " + element);
        }
        throw new RuntimeException("Element requires to be a JsonObject: " + element);
    }

    public static class PercentStat
    extends IStatPredicate {
        StatBase firstStat;
        StatBase secondStat;
        int percent;
        int baseValue;

        public PercentStat(String base, String other, int baseAmount, int percent) {
            this.firstStat = StatList.func_151177_a((String)base);
            this.secondStat = StatList.func_151177_a((String)other);
            this.percent = percent;
            this.baseValue = baseAmount;
        }

        @Override
        public boolean test(EntityPlayerMP player) {
            int second;
            StatisticsManagerServer server = player.func_147099_x();
            int first = server.func_77444_a(this.firstStat);
            if (first + (second = server.func_77444_a(this.secondStat)) < this.baseValue) {
                return false;
            }
            double total = first + second;
            return (int)((double)first / total * 100.0) >= this.percent;
        }
    }

    public static class NormalStat
    extends IStatPredicate {
        StatBase stat;
        int required;

        public NormalStat(String id, int value) {
            this.stat = StatList.func_151177_a((String)id);
            this.required = value;
        }

        @Override
        public boolean test(EntityPlayerMP player) {
            return player.func_147099_x().func_77444_a(this.stat) >= this.required;
        }
    }
}

