/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.InvertedFilter;
import ic2.core.inventory.filters.ListFilter;
import ic2.core.inventory.filters.SpecialItemFilter;
import ic2.core.inventory.filters.TupleFilter;
import ic2.core.item.inv.container.ContainerBaseMoveUpgrade;
import ic2.core.item.inv.inventories.BaseMoveUpgradeInv;
import ic2.core.item.upgrades.subtypes.machine.BaseMetaUpgrade;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public abstract class BaseFilteredUpgrade
extends BaseMetaUpgrade {
    @Override
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3, Map<ToolTipType, List<String>> toolTips) {
        super.addInfo(par1, par2, par3, toolTips);
        Set<String> targets = this.getTargets(par1);
        if (targets.size() > 0) {
            List<String> altList = toolTips.get((Object)ToolTipType.Alt);
            if (this.isInverted(par1)) {
                altList.add(Ic2InfoLang.isInverted.getLocalized());
                altList.add("");
            }
            altList.addAll(targets);
        }
    }

    @Override
    public boolean usesExtraRightClick(ItemStack item) {
        return true;
    }

    @Override
    public void onRightClick(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        if (IC2.keyboard.isSideinventoryKeyDown(player)) {
            IC2.platform.launchGui(player, this.getInventory(player, hand, item), hand);
        }
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new BaseMoveUpgradeInv(player, (IHandHeldInventory)stack.func_77973_b(), stack);
    }

    public IFilter getFilter(ItemStack stack) {
        LinkedList<IFilter> filters = new LinkedList<IFilter>();
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        boolean inverted = nbt.func_74767_n("isInverted");
        boolean useMeta = !nbt.func_74767_n("IgnoreMeta");
        boolean useNBT = nbt.func_74767_n("useNBT");
        boolean useOreDict = nbt.func_74767_n("useOreDict");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack item = new ItemStack(list.func_150305_b(i));
            if (item.func_190926_b()) continue;
            filters.add(new SpecialItemFilter(item, useMeta, useNBT, useOreDict));
        }
        if (inverted) {
            return new InvertedFilter(new ListFilter(filters));
        }
        return new ListFilter(filters);
    }

    public List<IFilter> getFilters(ItemStack stack, IFilter filter) {
        LinkedList<IFilter> filters = new LinkedList<IFilter>();
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        boolean useMeta = !nbt.func_74767_n("IgnoreMeta");
        boolean useNBT = nbt.func_74767_n("useNBT");
        boolean useOreDict = nbt.func_74767_n("useOreDict");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack item = new ItemStack(list.func_150305_b(i));
            if (item.func_190926_b()) continue;
            if (filter != null) {
                filters.add(new TupleFilter(new SpecialItemFilter(item, useMeta, useNBT, useOreDict), filter));
                continue;
            }
            filters.add(new SpecialItemFilter(item, useMeta, useNBT, useOreDict));
        }
        return filters;
    }

    public Set<String> getTargets(ItemStack stack) {
        LinkedHashSet<String> text = new LinkedHashSet<String>();
        NBTTagList list = StackUtil.getNbtData(stack).func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack item = new ItemStack(list.func_150305_b(i));
            if (item.func_190926_b()) continue;
            text.add(item.func_82833_r());
        }
        return text;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, ItemStack stack, int key) {
        if (player != null && player.field_71070_bA instanceof ContainerBaseMoveUpgrade) {
            BaseMoveUpgradeInv inv = (BaseMoveUpgradeInv)((ContainerBaseMoveUpgrade)player.field_71070_bA).getGuiHolder();
            if (key == 0) {
                inv.invert = !inv.invert;
            } else if (key == 1) {
                inv.useOreDict = !inv.useOreDict;
            } else if (key == 2) {
                inv.useNBTData = !inv.useNBTData;
            } else if (key == 3) {
                inv.ignoreMeta = !inv.ignoreMeta;
            }
        }
    }

    public boolean isInverted(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("isInverted");
    }

    @Override
    public boolean hasInventory(ItemStack stack) {
        return true;
    }
}

