/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.info;

import ic2.api.classic.tile.IInfoTile;
import ic2.core.block.base.util.info.misc.IProbeComponent;
import ic2.core.block.misc.tile.TileEntityBarrel;
import ic2.core.item.crop.ItemMugBooze;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Lang;
import java.awt.Color;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

public class BarrelInfo
implements IProbeComponent {
    TileEntityBarrel barrel;
    int type;

    public BarrelInfo(TileEntityBarrel tile, int data) {
        this.barrel = tile;
        this.type = data;
    }

    @Override
    public boolean canShow(EntityPlayer player) {
        return false;
    }

    @Override
    public String getDisplayText(EntityPlayer player) {
        switch (this.type) {
            case 0: {
                return Ic2InfoLang.beerType.getLocalizedFormatted(this.getComp());
            }
            case 1: {
                return Ic2InfoLang.beerWater.getLocalizedFormatted(this.barrel.boozeAmount, 32);
            }
            case 2: {
                return Ic2InfoLang.beerWheat.getLocalizedFormatted(this.barrel.wheatCount, 64);
            }
            case 3: {
                return Ic2InfoLang.beerHops.getLocalizedFormatted(this.barrel.hopsCount, 64);
            }
            case 4: {
                return Ic2InfoLang.beerAge.getLocalizedFormatted(this.barrel.age, this.getTotalTime());
            }
            case 5: {
                return Ic2InfoLang.beerRatioWheat.getLocalizedFormatted(this.getRatio(), 6);
            }
            case 6: {
                return Ic2InfoLang.beerRatioHops.getLocalizedFormatted(this.getRatio(), 6);
            }
            case 7: {
                return Ic2InfoLang.beerRatioTime.getLocalizedFormatted(this.getRatio(), 4);
            }
        }
        return Ic2Lang.nullKey.getLocalized();
    }

    private String getRatio() {
        switch (this.type) {
            case 5: {
                return this.barrel.detailed ? "?" : ItemMugBooze.getSolidComp(this.barrel.solidRatio).getLocalized();
            }
            case 6: {
                return this.barrel.detailed ? "?" : ItemMugBooze.getHopsComp(this.barrel.hopsRatio).getLocalized();
            }
            case 7: {
                return this.barrel.type == 2 ? Ic2Lang.nothingComp.getLocalized() : ItemMugBooze.getTimeComp(this.barrel.timeRatio).getLocalized();
            }
        }
        return "?";
    }

    private int getTotalTime() {
        if (this.barrel.type == 2) {
            return this.barrel.timeNedForRum(this.barrel.boozeAmount);
        }
        int x = this.barrel.timeRatio;
        if (x == 4) {
            x += 2;
        }
        return (int)(24000.0 * Math.pow(3.0, x));
    }

    private LocaleComp getComp() {
        switch (this.barrel.type) {
            case 1: {
                return Ic2InfoLang.beerBeer;
            }
            case 2: {
                return Ic2InfoLang.beerRum;
            }
        }
        return Ic2Lang.nothingComp;
    }

    @Override
    public IInfoTile.InfoType getType() {
        return IInfoTile.InfoType.Custom;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public boolean isModeValid(ProbeMode mode, PlayerHandler handler) {
        return mode != ProbeMode.NORMAL;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void applyInfo(IProbeInfo info, EntityPlayer player, EnumFacing side) {
        switch (this.type) {
            case 0: {
                info.text(Ic2InfoLang.beerType.getLocalizedFormatted(this.getComp()));
                break;
            }
            case 1: {
                info.progress(this.barrel.boozeAmount, 32, info.defaultProgressStyle().prefix("Water: "));
                break;
            }
            case 2: {
                info.progress(this.barrel.wheatCount, 64, info.defaultProgressStyle().filledColor(Color.YELLOW.getRGB()).prefix("Solids: "));
                break;
            }
            case 3: {
                info.progress(this.barrel.hopsCount, 64, info.defaultProgressStyle().filledColor(Color.GREEN.getRGB()).prefix("Hops: "));
                break;
            }
            case 4: {
                int total = this.getTotalTime();
                if (this.barrel.age > total) {
                    total = this.barrel.age;
                }
                info.progress(this.barrel.age, total, info.defaultProgressStyle().filledColor(Color.GRAY.getRGB()).prefix("Age: "));
                break;
            }
            case 5: {
                info.progress(this.barrel.detailed ? 0 : this.barrel.solidRatio, 6, info.defaultProgressStyle().filledColor(Color.YELLOW.getRGB()).prefix("SolidRatio: "));
                break;
            }
            case 6: {
                info.progress(this.barrel.detailed ? 0 : this.barrel.hopsRatio, 6, info.defaultProgressStyle().filledColor(Color.GREEN.getRGB()).prefix("HopRatio: "));
                break;
            }
            case 7: {
                info.progress(this.barrel.type == 2 ? 0 : this.barrel.timeRatio, 6, info.defaultProgressStyle().filledColor(Color.GRAY.getRGB()).prefix("TimeRatio: "));
            }
        }
    }
}

