/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.fluids.BlockForestryFluid;
import forestry.core.items.DrinkProperties;
import forestry.core.render.ForestryResource;
import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public enum Fluids {
    BIO_ETHANOL(new Color(255, 111, 0), 790, 1000){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 300, true);
        }
    }
    ,
    BIOMASS(new Color(100, 132, 41), 400, 6560){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 100, true);
        }
    }
    ,
    GLASS(new Color(164, 164, 164), 2400, 10000){

        @Override
        public int getTemperature() {
            return 1200;
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 0, true);
        }
    }
    ,
    FOR_HONEY(new Color(255, 196, 35), 1420, 75600){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public DrinkProperties getDrinkProperties() {
            return new DrinkProperties(2, 0.2f, 64);
        }
    }
    ,
    ICE(new Color(175, 242, 255), 520, 1000){

        @Override
        public int getTemperature() {
            return 265;
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }
    }
    ,
    JUICE(new Color(168, 201, 114)){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public DrinkProperties getDrinkProperties() {
            return new DrinkProperties(2, 0.2f, 32);
        }
    }
    ,
    MILK(new Color(255, 255, 255), 1030, 3000){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public List<ItemStack> getOtherContainers() {
            return Collections.singletonList(new ItemStack(Items.field_151117_aB));
        }
    }
    ,
    SEED_OIL(new Color(255, 255, 168), 885, 5000){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 2, true);
        }
    }
    ,
    SHORT_MEAD(new Color(239, 154, 56), 1000, 1200){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 4, true);
        }

        @Override
        public DrinkProperties getDrinkProperties() {
            return new DrinkProperties(1, 0.2f, 32);
        }
    };

    private static final Map<String, Fluids> tagToFluid;
    private final String tag;
    private final int density;
    private final int viscosity;
    private final Color particleColor;
    private final ResourceLocation[] resources = new ResourceLocation[2];

    private Fluids(Color particleColor) {
        this(particleColor, 1000, 1000);
    }

    private Fluids(Color particleColor, int density, int viscosity) {
        this.tag = this.name().toLowerCase(Locale.ENGLISH).replace('_', '.');
        this.particleColor = particleColor;
        this.density = density;
        this.viscosity = viscosity;
        this.resources[0] = new ForestryResource("blocks/liquid/" + this.getTag() + "_still");
        if (this.flowTextureExists()) {
            this.resources[1] = new ForestryResource("blocks/liquid/" + this.getTag() + "_flow");
        }
    }

    public int getTemperature() {
        return 295;
    }

    public final String getTag() {
        return this.tag;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    @Nullable
    public final Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.getTag());
    }

    @Nullable
    public final FluidStack getFluid(int mb) {
        return FluidRegistry.getFluidStack((String)this.getTag(), (int)mb);
    }

    public final Color getParticleColor() {
        return this.particleColor;
    }

    public final boolean is(Fluid fluid) {
        return this.getFluid() == fluid;
    }

    public final boolean is(FluidStack fluidStack) {
        return this.getFluid() == fluidStack.getFluid();
    }

    public static boolean areEqual(@Nullable Fluid fluid, FluidStack fluidStack) {
        return fluid == fluidStack.getFluid();
    }

    @Nullable
    public static Fluids getFluidDefinition(@Nullable FluidStack fluidStack) {
        Fluids fluidDefinition;
        Fluid fluid;
        if (fluidStack != null && (fluid = fluidStack.getFluid()) != null && (fluidDefinition = tagToFluid.get(fluid.getName())) != null) {
            return fluidDefinition;
        }
        return null;
    }

    public List<ItemStack> getOtherContainers() {
        return Collections.emptyList();
    }

    @Nullable
    public Block makeBlock() {
        return null;
    }

    @Nullable
    public DrinkProperties getDrinkProperties() {
        return null;
    }

    public boolean flowTextureExists() {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return true;
        }
        try {
            ForestryResource resourceLocation = new ForestryResource("blocks/liquid/" + this.getTag() + "_flow");
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft != null) {
                IResourceManager resourceManager = minecraft.func_110442_L();
                return resourceManager.func_110536_a((ResourceLocation)resourceLocation) != null;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public ResourceLocation[] getResources() {
        return this.resources;
    }

    static {
        tagToFluid = new HashMap<String, Fluids>();
        for (Fluids fluidDefinition : Fluids.values()) {
            tagToFluid.put(fluidDefinition.getTag(), fluidDefinition);
        }
    }
}

