/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.schedule;

import com.google.common.base.Preconditions;
import com.mcsimonflash.sponge.cmdscheduler.internal.Utils;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Schedule;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.spongepowered.api.util.ResettableBuilder;

public class CalendarSchedule
implements Schedule {
    public static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd/HH:mm:ss.SSS");
    private final Calendar calendar;
    private final long interval;

    private CalendarSchedule(Calendar calendar, long interval) {
        this.calendar = calendar;
        this.interval = interval;
    }

    @Override
    public long getDelay(Calendar calendar) {
        return this.calendar.getTimeInMillis() - calendar.getTimeInMillis();
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendar.clone();
    }

    public long getTime() {
        return this.calendar.getTimeInMillis();
    }

    public String getDate() {
        return FORMAT.format(this.calendar.getTime());
    }

    public String toString() {
        return "CalendarSchedule{date=" + this.getDate() + ", interval=" + Utils.printTime(this.interval) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ResettableBuilder<CalendarSchedule, Builder> {
        @Nullable
        private Calendar calendar;
        private long interval = 0L;

        public Builder from(CalendarSchedule value) {
            this.calendar = value.getCalendar();
            this.interval = value.getInterval();
            return this;
        }

        public Builder reset() {
            this.calendar = null;
            this.interval = 0L;
            return this;
        }

        public Builder calendar(Calendar calendar) {
            this.calendar = (Calendar)calendar.clone();
            return this;
        }

        public Builder time(long time) {
            this.calendar = Calendar.getInstance();
            this.calendar.setTimeInMillis(time);
            return this;
        }

        public Builder date(String date) {
            Preconditions.checkArgument((!date.isEmpty() ? 1 : 0) != 0, (Object)"Date must be defined.");
            try {
                this.time(FORMAT.parse(date).getTime());
                return this;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Date does not match format. | Date:[" + date + "]", e);
            }
        }

        public Builder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder interval(long interval, TimeUnit unit) throws IllegalArgumentException {
            return this.interval(unit.toMillis(interval));
        }

        public CalendarSchedule build() throws IllegalArgumentException {
            Preconditions.checkArgument((this.calendar != null ? 1 : 0) != 0, (Object)"Calendar must be defined.");
            Preconditions.checkArgument((this.interval >= 0L ? 1 : 0) != 0, (Object)("Interval cannot be negative. | Interval:[" + this.interval + "]"));
            return new CalendarSchedule(this.calendar, this.interval);
        }
    }
}

