/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.therandomlabs.randompatches.core.Patch;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class ItemBucketPatch
extends Patch {
    public static final String IS_SOLID = ItemBucketPatch.getName("isSolid", "func_76220_a");

    @Override
    public boolean apply(ClassNode node) {
        MethodNode method = ItemBucketPatch.findMethod(node, "tryPlaceContainedLiquid");
        if (method == null) {
            method = ItemBucketPatch.findMethod(node, "func_180616_a");
        }
        InsnList instructions = method.instructions;
        MethodInsnNode isSolid = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 182) continue;
            isSolid = (MethodInsnNode)instruction;
            if (IS_SOLID.equals(isSolid.name)) break;
            isSolid = null;
        }
        ((VarInsnNode)isSolid.getPrevious()).var = StringUtils.countMatches((CharSequence)method.desc, (char)';') + 1;
        isSolid.setOpcode(184);
        isSolid.owner = this.hookClass;
        isSolid.name = "isSolid";
        isSolid.desc = "(Lnet/minecraft/block/state/IBlockState;)Z";
        return true;
    }
}

