/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.timings.TimeTracker;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.bridge.world.DimensionTypeBridge;
import org.spongepowered.common.bridge.world.ForgeITeleporterBridge;
import org.spongepowered.common.command.SpongeCommandFactory;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.util.InventoryUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.registry.type.block.TileEntityTypeRegistryModule;
import org.spongepowered.common.registry.type.entity.ProfessionRegistryModule;
import org.spongepowered.common.registry.type.world.PortalAgentRegistryModule;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.SpawnerSpawnType;
import org.spongepowered.common.util.TristateUtil;
import org.spongepowered.mod.bridge.block.BlockBridge_Forge;
import org.spongepowered.mod.bridge.event.EventBusBridge_Forge;
import org.spongepowered.mod.bridge.item.ItemStackBridge_Forge;
import org.spongepowered.mod.bridge.registry.VillagerProfessionBridge_Forge;
import org.spongepowered.mod.command.SpongeForgeCommandFactory;
import org.spongepowered.mod.event.SpongeModEventManager;
import org.spongepowered.mod.event.SpongeToForgeEventData;
import org.spongepowered.mod.item.inventory.adapter.IItemHandlerAdapter;
import org.spongepowered.mod.mixin.core.fml.common.registry.VillagerRegistryAccessor;
import org.spongepowered.mod.plugin.SpongeModPluginContainer;
import org.spongepowered.mod.util.StaticMixinForgeHelper;
import org.spongepowered.mod.util.WrappedArrayList;

@Mixin(value={SpongeImplHooks.class}, remap=false)
public abstract class SpongeImplHooksMixin_Forge {
    private static Boolean forgeImpl$deobfuscatedEnvironment;

    @Overwrite
    public static boolean isVanilla() {
        return false;
    }

    @Overwrite
    public static double getWorldMaxEntityRadius(WorldServer mixinWorldServer) {
        return WorldServer.MAX_ENTITY_RADIUS;
    }

    @Overwrite
    public static boolean isClientAvailable() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    @Overwrite
    public static boolean isDeobfuscatedEnvironment() {
        if (forgeImpl$deobfuscatedEnvironment != null) {
            return forgeImpl$deobfuscatedEnvironment;
        }
        forgeImpl$deobfuscatedEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        return forgeImpl$deobfuscatedEnvironment;
    }

    @Overwrite
    public static String getModIdFromClass(Class<?> clazz) {
        return StaticMixinForgeHelper.getModIdFromClass(clazz);
    }

    @Overwrite
    public static boolean isCreatureOfType(Entity entity, EnumCreatureType type) {
        return entity.isCreatureType(type, false);
    }

    @Overwrite
    public static boolean isFakePlayer(Entity entity) {
        return entity instanceof FakePlayer;
    }

    @Overwrite
    public static void fireServerConnectionEvent(NetworkManager netManager) {
        FMLCommonHandler.instance().fireServerConnectionEvent(netManager);
    }

    @Overwrite
    public static void firePlayerJoinSpawnEvent(EntityPlayerMP playerMP) {
        ((EventBusBridge_Forge)MinecraftForge.EVENT_BUS).forgeBridge$post((Event)new EntityJoinWorldEvent((Entity)playerMP, playerMP.func_130014_f_()), true);
    }

    @Overwrite
    public static void handlePostChangeDimensionEvent(EntityPlayerMP playerIn, WorldServer fromWorld, WorldServer toWorld) {
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)playerIn, fromWorld.field_73011_w.getDimension(), toWorld.field_73011_w.getDimension());
    }

    @Overwrite
    public static boolean checkAttackEntity(EntityPlayer entityPlayer, Entity targetEntity) {
        return ForgeHooks.onPlayerAttackTarget((EntityPlayer)entityPlayer, (Entity)targetEntity);
    }

    @Overwrite
    public static double getBlockReachDistance(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    @Overwrite
    public static double getEntityReachDistanceSq(EntityPlayerMP player, Entity entity) {
        double reach = SpongeImplHooksMixin_Forge.getBlockReachDistance(player);
        return reach * reach;
    }

    @Nullable
    @Overwrite
    public static Class<? extends Entity> getEntityClass(ResourceLocation name) {
        return EntityList.getClass((ResourceLocation)name);
    }

    @Overwrite
    public static int getEntityId(Class<? extends Entity> entityClass) {
        return EntityList.getID(entityClass);
    }

    @Overwrite
    public static boolean isBlockFlammable(Block block, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return block.isFlammable(world, pos, face);
    }

    @Overwrite
    public static int getBlockLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.getLightOpacity(world, pos);
    }

    @Overwrite
    public static int getChunkPosLight(IBlockState blockState, net.minecraft.world.World worldObj, BlockPos pos) {
        if (((BlockBridge_Forge)blockState.func_177230_c()).forgeBridge$requiresLocationCheckForLightValue()) {
            return blockState.getLightValue((IBlockAccess)worldObj, pos);
        }
        return blockState.func_185906_d();
    }

    @Nullable
    @Overwrite
    public static TileEntity createTileEntity(Block block, net.minecraft.world.World world, IBlockState state) {
        return block.createTileEntity(world, state);
    }

    @Overwrite
    public static boolean hasBlockTileEntity(Block block, IBlockState state) {
        return block.hasTileEntity(state);
    }

    @Overwrite
    public static boolean shouldRefresh(TileEntity tile, net.minecraft.world.World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return tile.shouldRefresh(world, pos, oldState, newState);
    }

    @Overwrite
    public static void onTileChunkUnload(TileEntity te) {
        if (te == null) {
            return;
        }
        if (!te.func_145831_w().field_72995_K) {
            try (Object o = ((PhaseContext)BlockPhase.State.TILE_CHUNK_UNLOAD.createPhaseContext()).source(te);){
                ((PhaseContext)o).buildAndSwitch();
                te.onChunkUnload();
            }
        }
    }

    @Overwrite
    public static Iterator<Chunk> getChunkIterator(WorldServer world) {
        return world.getPersistentChunkIterable(world.func_184164_w().func_187300_b());
    }

    @Overwrite
    public static void registerPortalAgentType(@Nullable ForgeITeleporterBridge teleporter) {
        if (teleporter == null) {
            return;
        }
        PortalAgentRegistryModule.getInstance().validatePortalAgent(teleporter);
    }

    @Overwrite
    public static boolean canDoLightning(WorldProvider provider, Chunk chunk) {
        return provider.canDoLightning(chunk);
    }

    @Overwrite
    public static boolean canDoRainSnowIce(WorldProvider provider, Chunk chunk) {
        return provider.canDoRainSnowIce(chunk);
    }

    @Overwrite
    public static int getRespawnDimension(WorldProvider targetDimension, EntityPlayerMP player) {
        return targetDimension.getRespawnDimension(player);
    }

    @Overwrite
    public static BlockPos getRandomizedSpawnPoint(WorldServer world) {
        return world.field_73011_w.getRandomizedSpawnPoint();
    }

    @Overwrite
    public static MapStorage getWorldMapStorage(net.minecraft.world.World world) {
        return world.getPerWorldStorage();
    }

    @Overwrite
    public static int countEntities(WorldServer worldServer, EnumCreatureType type, boolean forSpawnCount) {
        return worldServer.countEntities(type, forSpawnCount);
    }

    @Overwrite
    public static int getMaxSpawnPackSize(EntityLiving entityLiving) {
        return ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityLiving);
    }

    @Overwrite
    public static SpawnerSpawnType canEntitySpawnHere(EntityLiving entityLiving, boolean entityNotColliding) {
        net.minecraft.world.World world = entityLiving.field_70170_p;
        float x = (float)entityLiving.field_70165_t;
        float y = (float)entityLiving.field_70163_u;
        float z = (float)entityLiving.field_70161_v;
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityLiving, (net.minecraft.world.World)world, (float)x, (float)y, (float)z, (boolean)false);
        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityLiving.func_70601_bi() && entityNotColliding) {
            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityLiving, (net.minecraft.world.World)world, (float)x, (float)y, (float)z)) {
                return SpawnerSpawnType.NORMAL;
            }
            return SpawnerSpawnType.SPECIAL;
        }
        return SpawnerSpawnType.NONE;
    }

    @Overwrite
    public static void onEntityError(Entity entity, CrashReport crashReport) {
        if (!ForgeModContainer.removeErroringEntities) {
            throw new ReportedException(crashReport);
        }
        FMLRelaunchLog.log.getLogger().log(Level.ERROR, crashReport.func_71502_e());
        entity.func_130014_f_().func_72900_e(entity);
    }

    @Overwrite
    public static void onTileEntityError(TileEntity tileEntity, CrashReport crashReport) {
        if (!ForgeModContainer.removeErroringTileEntities) {
            throw new ReportedException(crashReport);
        }
        FMLRelaunchLog.log.getLogger().log(Level.ERROR, crashReport.func_71502_e());
        tileEntity.func_145843_s();
        tileEntity.func_145831_w().func_175713_t(tileEntity.func_174877_v());
    }

    @Overwrite
    public static void blockExploded(Block block, net.minecraft.world.World world, BlockPos blockpos, Explosion explosion) {
        block.onBlockExploded(world, blockpos, explosion);
    }

    @Overwrite
    public static boolean isRestoringBlocks(net.minecraft.world.World world) {
        return world.restoringBlockSnapshots || PhaseTracker.getInstance().getCurrentState().isRestoring();
    }

    @Overwrite
    public static void onTileEntityChunkUnload(TileEntity tileEntity) {
        tileEntity.onChunkUnload();
    }

    @Overwrite
    public static boolean canConnectRedstone(Block block, IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return block.canConnectRedstone(state, world, pos, side);
    }

    @Overwrite
    public static void setShouldLoadSpawn(DimensionType dimensionType, boolean keepSpawnLoaded) {
        ((DimensionTypeBridge)dimensionType).setShouldLoadSpawn(keepSpawnLoaded);
    }

    @Overwrite
    public static BlockPos getBedLocation(EntityPlayer player, int dimension) {
        return player.getBedLocation(dimension);
    }

    @Overwrite
    public static boolean isSpawnForced(EntityPlayer player, int dimension) {
        return player.isSpawnForced(dimension);
    }

    @Overwrite
    public static Optional<org.spongepowered.api.item.inventory.ItemStack> getContainerItem(org.spongepowered.api.item.inventory.ItemStack itemStack) {
        ItemStack nmsStack = ItemStackUtil.toNative(itemStack);
        ItemStack nmsContainerStack = ForgeHooks.getContainerItem((ItemStack)nmsStack);
        if (nmsContainerStack.func_190926_b()) {
            return Optional.empty();
        }
        return Optional.of(ItemStackUtil.fromNative(nmsContainerStack));
    }

    @Overwrite
    public static Optional<CraftingRecipe> findMatchingRecipe(CraftingGridInventory inventory, World world) {
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)InventoryUtil.toNativeInventory(inventory), (net.minecraft.world.World)((net.minecraft.world.World)world));
        return Optional.ofNullable((CraftingRecipe)recipe);
    }

    @Overwrite
    public static Collection<CraftingRecipe> getCraftingRecipes() {
        return (Collection)ForgeRegistries.RECIPES.getValues().stream().map(CraftingRecipe.class::cast).collect(ImmutableList.toImmutableList());
    }

    @Overwrite
    public static Optional<CraftingRecipe> getRecipeById(String id) {
        IRecipe recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation(id));
        if (recipe == null) {
            return Optional.empty();
        }
        return Optional.of((CraftingRecipe)recipe);
    }

    @Overwrite
    public static void register(ResourceLocation name, IRecipe recipe) {
        recipe.setRegistryName(name);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    @Nullable
    @Overwrite
    public static PluginContainer getActiveModContainer() {
        return (PluginContainer)Loader.instance().activeModContainer();
    }

    @Overwrite
    public static Text getAdditionalCommandDescriptions() {
        return Text.of("    ", SpongeCommandFactory.title("mods"), "        ", "List currently installed mods");
    }

    @Overwrite
    public static void registerAdditionalCommands(ChildCommandElementExecutor flagChildren, ChildCommandElementExecutor nonFlagChildren) {
        nonFlagChildren.register((CommandCallable)SpongeForgeCommandFactory.createSpongeModsCommand(), "mods");
    }

    @Overwrite
    public static Predicate<PluginContainer> getPluginFilterPredicate() {
        return plugin -> !SpongeCommandFactory.CONTAINER_LIST_STATICS.contains(plugin.getId()) && plugin instanceof SpongeModPluginContainer;
    }

    @Overwrite
    public static Inventory toInventory(Object inventory, @Nullable Object forgeItemHandler) {
        IItemHandler itemHandler;
        if (forgeItemHandler instanceof Inventory) {
            return (Inventory)forgeItemHandler;
        }
        if (inventory instanceof ICapabilityProvider && (itemHandler = (IItemHandler)((ICapabilityProvider)inventory).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            return (Inventory)itemHandler;
        }
        if (inventory instanceof Inventory) {
            return (Inventory)inventory;
        }
        String fallbackName = forgeItemHandler == null ? "no forgeItemHandler" : forgeItemHandler.getClass().getName();
        SpongeImpl.getLogger().error("Unknown inventory " + inventory.getClass().getName() + " and " + fallbackName + " report this to Sponge");
        return null;
    }

    @Overwrite
    public static InventoryAdapter findInventoryAdapter(Object inventory) {
        if (inventory instanceof ICapabilityProvider) {
            IItemHandler itemHandler = (IItemHandler)((ICapabilityProvider)inventory).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (itemHandler instanceof InventoryAdapter) {
                return (InventoryAdapter)itemHandler;
            }
            if (itemHandler != null) {
                return new IItemHandlerAdapter(itemHandler);
            }
        }
        if (inventory instanceof IItemHandler) {
            return new IItemHandlerAdapter((IItemHandler)inventory);
        }
        if (inventory instanceof IInventory) {
            return (InventoryAdapter)new InvWrapper((IInventory)inventory);
        }
        SpongeImpl.getLogger().error("Unknown inventory " + inventory.getClass().getName() + " report this to Sponge");
        throw new IllegalArgumentException("Unknown inventory " + inventory.getClass().getName() + " report this to Sponge");
    }

    @Overwrite
    public static void onTileEntityInvalidate(TileEntity te) {
        try (Object o = ((PhaseContext)BlockPhase.State.TILE_ENTITY_INVALIDATING.createPhaseContext()).source(te);){
            ((PhaseContext)o).buildAndSwitch();
            te.func_145843_s();
        }
    }

    @Overwrite
    public static void capturePerEntityItemDrop(PhaseContext<?> phaseContext, Entity owner, EntityItem entityitem) {
        ArrayList capturedDrops = owner.capturedDrops;
        ArrayListMultimap<UUID, EntityItem> map = phaseContext.getPerEntityItemEntityDropSupplier().get();
        WrappedArrayList entityItems = new WrappedArrayList(owner, map.get((Object)owner.func_110124_au()));
        if (capturedDrops != entityItems) {
            owner.capturedDrops = entityItems;
            if (!capturedDrops.isEmpty()) {
                ((ArrayList)entityItems).addAll(capturedDrops);
            }
        }
        ((ArrayList)entityItems).add(entityitem);
    }

    @Overwrite
    public static int getLootingEnchantmentModifier(EntityLivingBase mixinEntityLivingBase, EntityLivingBase entity, DamageSource cause) {
        return ForgeHooks.getLootingLevel((Entity)mixinEntityLivingBase, (Entity)entity, (DamageSource)cause);
    }

    @Overwrite
    public static Profession validateProfession(int professionId) {
        VillagerRegistry.VillagerProfession profession = (VillagerRegistry.VillagerProfession)((VillagerRegistryAccessor)VillagerRegistry.instance()).accessor$getRegistry().func_148754_a(professionId);
        if (profession == null) {
            throw new RuntimeException("Attempted to set villager profession to unregistered profession: " + professionId);
        }
        VillagerProfessionBridge_Forge mixinProfession = (VillagerProfessionBridge_Forge)profession;
        return mixinProfession.forgeBridge$getSpongeProfession().orElseGet(() -> {
            SpongeProfession newProfession = new SpongeProfession(professionId, mixinProfession.forgeBridge$getId(), mixinProfession.forgeBridge$getProfessionName());
            mixinProfession.forgeBridge$setSpongeProfession(newProfession);
            ProfessionRegistryModule.getInstance().registerAdditionalCatalog(newProfession);
            return newProfession;
        });
    }

    @Overwrite
    public static void onUseItemTick(EntityLivingBase entity, ItemStack stack, int activeItemStackUseCount) {
        if (!stack.func_190926_b() && activeItemStackUseCount > 0) {
            stack.func_77973_b().onUsingTick(stack, entity, activeItemStackUseCount);
        }
    }

    @Overwrite
    public static void onTETickStart(TileEntity tileentity) {
        TimeTracker.TILE_ENTITY_UPDATE.trackStart((Object)tileentity);
    }

    @Overwrite
    public static void onTETickEnd(TileEntity tileentity) {
        TimeTracker.TILE_ENTITY_UPDATE.trackEnd((Object)tileentity);
    }

    @Overwrite
    public static void onEntityTickStart(Entity entity) {
        TimeTracker.ENTITY_UPDATE.trackStart((Object)entity);
    }

    @Overwrite
    public static void onEntityTickEnd(Entity entity) {
        TimeTracker.ENTITY_UPDATE.trackEnd((Object)entity);
    }

    @Overwrite
    public static String getImplementationId() {
        return "spongeforge";
    }

    @Overwrite
    public static TileEntityType getTileEntityType(Class<? extends TileEntityBridge> aClass) {
        ResourceLocation location = TileEntity.func_190559_a(aClass);
        if (location == null) {
            return null;
        }
        TileEntityType translated = SpongeImpl.getRegistry().getTranslated(aClass, TileEntityType.class);
        if (translated == null) {
            return TileEntityTypeRegistryModule.getInstance().doTileEntityRegistration(aClass, location.func_110623_a());
        }
        return translated;
    }

    @Overwrite
    @Nullable
    public static Object postForgeEventDataCompatForSponge(InteractBlockEvent.Secondary spongeEvent) {
        return ((SpongeModEventManager)Sponge.getEventManager()).extendedPost(spongeEvent, false, false);
    }

    @Overwrite
    public static void shouldCloseScreen(net.minecraft.world.World worldIn, BlockPos pos, @Nullable Object eventData, EntityPlayerMP player) {
        if (worldIn.func_175625_s(pos) != null && player.field_71070_bA instanceof ContainerPlayer && (eventData == null || !((SpongeToForgeEventData)eventData).getForgeEvent().isCanceled())) {
            player.func_71053_j();
        }
    }

    @Overwrite
    public static EnumActionResult getInteractionCancellationResult(@Nullable Object forgeEventObject) {
        SpongeToForgeEventData eventData = (SpongeToForgeEventData)forgeEventObject;
        return eventData == null ? EnumActionResult.PASS : ((PlayerInteractEvent)eventData.getForgeEvent()).getCancellationResult();
    }

    @Overwrite
    public static boolean doesItemSneakBypass(net.minecraft.world.World worldIn, BlockPos pos, EntityPlayer player, ItemStack main, ItemStack off) {
        boolean bypass = main.func_190926_b() || main.func_77973_b().doesSneakBypassUse(main, (IBlockAccess)worldIn, pos, player);
        bypass = bypass && (off.func_190926_b() || off.func_77973_b().doesSneakBypassUse(off, (IBlockAccess)worldIn, pos, player));
        return bypass;
    }

    @Nullable
    @Overwrite
    public static EnumActionResult getEnumResultForProcessRightClickBlock(EntityPlayerMP player, InteractBlockEvent.Secondary event, EnumActionResult result, net.minecraft.world.World worldIn, BlockPos pos, EnumHand hand) {
        result = TristateUtil.toActionResult(event.getUseItemResult());
        if (result != EnumActionResult.SUCCESS && worldIn.func_175625_s(pos) != null && hand == EnumHand.MAIN_HAND) {
            player.func_71053_j();
        }
        return null;
    }

    @Overwrite
    public static EnumActionResult onForgeItemUseFirst(EntityPlayer player, ItemStack stack, net.minecraft.world.World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return stack.onItemUseFirst(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Nullable
    @Overwrite
    public static Entity getCustomEntityIfItem(Entity entity) {
        Entity newEntity;
        ItemStack stack = entity instanceof EntityItem ? ((EntityItem)entity).func_92059_d() : ItemStack.field_190927_a;
        Item item = stack.func_77973_b();
        if (item.hasCustomEntity(stack) && (newEntity = item.createEntity(entity.func_130014_f_(), entity, stack)) != null) {
            entity.func_70106_y();
            return newEntity;
        }
        return null;
    }

    @Overwrite
    @Nullable
    public static ResourceLocation getItemResourceLocation(Item mixinItem_api) {
        return mixinItem_api.getRegistryName();
    }

    @Overwrite
    public static void registerItemForSpongeRegistry(int id, ResourceLocation name, Item item) {
        ResourceLocation nameForObject = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        Item registered = nameForObject == null ? (Item)Preconditions.checkNotNull((Object)Item.field_150901_e.func_82594_a((Object)name), (Object)"Someone replaced a vanilla item with a null item!!!") : item;
        ItemTypeRegistryModule.getInstance().registerAdditionalCatalog((ItemType)registered);
    }

    @Overwrite
    public static void writeItemStackCapabilitiesToDataView(DataContainer container, ItemStack stack) {
        NBTTagCompound caps;
        CapabilityDispatcher capabilities = ((ItemStackBridge_Forge)stack).forgeBridge$getCapabilities();
        if (capabilities != null && (caps = capabilities.serializeNBT()) != null && !caps.func_82582_d()) {
            DataContainer capsView = NbtTranslator.getInstance().translate(caps);
            container.set(Constants.Sponge.UNSAFE_NBT.then("ForgeCaps"), (Object)capsView);
        }
    }

    @Overwrite
    public static boolean canEnchantmentBeAppliedToItem(Enchantment enchantment, ItemStack stack) {
        return stack.func_77973_b() == ItemTypes.BOOK ? enchantment.isAllowedOnBooks() : enchantment.func_92089_a(stack);
    }

    @Overwrite
    public static void setCapabilitiesFromSpongeBuilder(org.spongepowered.api.item.inventory.ItemStack stack, NBTTagCompound compoundTag) {
        CapabilityDispatcher capabilities = ((ItemStackBridge_Forge)((Object)stack)).forgeBridge$getCapabilities();
        if (capabilities != null) {
            capabilities.deserializeNBT(compoundTag);
        }
    }

    @Overwrite
    public static void onForgeCollision(net.minecraft.world.World world, @Nullable Entity entityIn, AxisAlignedBB aabb, List<AxisAlignedBB> collided) {
        MinecraftForge.EVENT_BUS.post((Event)new GetCollisionBoxesEvent(world, entityIn, aabb, collided));
    }
}

