/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.permission.base.SpongeSubject;

public class SpongeSubjectReference
implements SubjectReference {
    private final SpongePermissionService service;
    private final String collectionId;
    private final String subjectId;
    @Nullable
    private SpongeSubject cache = null;

    public SpongeSubjectReference(SpongePermissionService service, String collectionId, String subjectId) {
        this.service = service;
        this.collectionId = collectionId;
        this.subjectId = subjectId;
    }

    @Override
    public String getCollectionIdentifier() {
        return this.collectionId;
    }

    @Override
    public String getSubjectIdentifier() {
        return this.subjectId;
    }

    @Override
    public synchronized CompletableFuture<Subject> resolve() {
        if (this.cache == null) {
            this.cache = this.service.get(this.collectionId).get(this.subjectId);
        }
        return CompletableFuture.completedFuture(this.cache);
    }
}

