/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.EnumDifficulty;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.difficulty.Difficulties;
import org.spongepowered.api.world.difficulty.Difficulty;

public final class DifficultyRegistryModule
implements AlternateCatalogRegistryModule<Difficulty> {
    @RegisterCatalog(value=Difficulties.class)
    private final Map<String, Difficulty> difficultyMappings = new HashMap<String, Difficulty>();

    public static DifficultyRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Optional<Difficulty> getById(String id) {
        Preconditions.checkNotNull((Object)id);
        if (!id.contains(":") && !id.equals("none")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.difficultyMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<Difficulty> getAll() {
        return ImmutableList.copyOf(this.difficultyMappings.values());
    }

    @Override
    public Map<String, Difficulty> provideCatalogMap() {
        HashMap<String, Difficulty> newMap = new HashMap<String, Difficulty>();
        for (Map.Entry<String, Difficulty> entry : this.difficultyMappings.entrySet()) {
            newMap.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return newMap;
    }

    @Override
    public void registerDefaults() {
        this.difficultyMappings.put("minecraft:peaceful", (Difficulty)EnumDifficulty.PEACEFUL);
        this.difficultyMappings.put("minecraft:easy", (Difficulty)EnumDifficulty.EASY);
        this.difficultyMappings.put("minecraft:normal", (Difficulty)EnumDifficulty.NORMAL);
        this.difficultyMappings.put("minecraft:hard", (Difficulty)EnumDifficulty.HARD);
    }

    @AdditionalRegistration
    public void additional() {
        for (EnumDifficulty difficulty : EnumDifficulty.values()) {
            if (this.difficultyMappings.containsValue(difficulty)) continue;
            this.difficultyMappings.put(difficulty.name(), (Difficulty)difficulty);
        }
    }

    private static final class Holder {
        static final DifficultyRegistryModule INSTANCE = new DifficultyRegistryModule();

        private Holder() {
        }
    }
}

