/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.gen.feature;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3i;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenIceSpike;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.IceSpike;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={WorldGenIceSpike.class})
public abstract class WorldGenIceSpikeMixin_API
extends WorldGenerator
implements IceSpike {
    private VariableAmount api$height = VariableAmount.baseWithRandomAddition(7.0, 4.0);
    private VariableAmount api$increase = VariableAmount.baseWithRandomAddition(10.0, 30.0);
    private VariableAmount api$count = VariableAmount.fixed(2.0);
    private double api$probability = 0.0166667;

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.ICE_SPIKE;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.api$count.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            this.func_180709_b(world, random, world.func_175645_m(chunkPos.func_177982_a(x, 0, z)));
        }
    }

    @Override
    public VariableAmount getHeight() {
        return this.api$height;
    }

    @Override
    public void setHeight(VariableAmount height) {
        this.api$height = height;
    }

    @Override
    public double getExtremeSpikeProbability() {
        return this.api$probability;
    }

    @Override
    public void setExtremeSpikeProbability(double p) {
        this.api$probability = GenericMath.clamp(p, 0.0, 1.0);
    }

    @Override
    public VariableAmount getExtremeSpikeIncrease() {
        return this.api$increase;
    }

    @Override
    public void setExtremeSpikeIncrease(VariableAmount increase) {
        this.api$increase = increase;
    }

    @Override
    public VariableAmount getSpikesPerChunk() {
        return this.api$count;
    }

    @Override
    public void setSpikesPerChunk(VariableAmount count) {
        this.api$count = count;
    }
}

