/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;

public class BasicPacketContext
extends PacketContext<BasicPacketContext> {
    @Nullable
    private Container container;

    public BasicPacketContext(PacketState<? extends BasicPacketContext> state) {
        super(state);
    }

    public BasicPacketContext openContainer(Container openContainer) {
        this.container = openContainer;
        return this;
    }

    public Container getOpenContainer() {
        return (Container)Preconditions.checkNotNull((Object)this.container, (Object)"Open Container was null!");
    }

    @Override
    public boolean hasCaptures() {
        if (this.state == PacketPhase.General.RESOURCE_PACK) {
            return true;
        }
        if (this.state == PacketPhase.General.CLOSE_WINDOW) {
            return true;
        }
        return super.hasCaptures();
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s + "- %s: %s", "OpenContainer", this.container);
    }

    @Override
    protected void reset() {
        super.reset();
        this.container = null;
    }
}

