/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutablePickupDelayData;
import org.spongepowered.api.data.manipulator.mutable.entity.PickupDelayData;
import org.spongepowered.common.bridge.entity.EntityItemBridge;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongePickupDelayData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataUtil;

public final class PickupDelayDataProcessor
extends AbstractEntityDataProcessor<EntityItem, PickupDelayData, ImmutablePickupDelayData> {
    public PickupDelayDataProcessor() {
        super(EntityItem.class);
    }

    @Override
    protected boolean doesDataExist(EntityItem container) {
        return true;
    }

    @Override
    protected boolean set(EntityItem container, Map<Key<?>, Object> keyValues) {
        ((EntityItemBridge)container).bridge$setPickupDelay((Integer)keyValues.get(Keys.PICKUP_DELAY), (Boolean)keyValues.get(Keys.INFINITE_PICKUP_DELAY));
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityItem container) {
        return ImmutableMap.builder().put(Keys.PICKUP_DELAY, (Object)((EntityItemBridge)container).bridge$getPickupDelay()).put(Keys.INFINITE_PICKUP_DELAY, (Object)((EntityItemBridge)container).bridge$infinitePickupDelay()).build();
    }

    @Override
    protected PickupDelayData createManipulator() {
        return new SpongePickupDelayData();
    }

    @Override
    public Optional<PickupDelayData> fill(DataContainer container, PickupDelayData data) {
        data.set(Keys.PICKUP_DELAY, DataUtil.getData(container, Keys.PICKUP_DELAY));
        return Optional.of(data);
    }

    @Override
    public DataTransactionResult remove(DataHolder container) {
        return DataTransactionResult.failNoData();
    }
}

