/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.monster.EntitySlime;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableSlimeData;
import org.spongepowered.api.data.manipulator.mutable.entity.SlimeData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeSlimeData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.mixin.core.entity.monster.EntitySlimeAccessor;
import org.spongepowered.common.util.Constants;

public class SlimeDataProcessor
extends AbstractEntitySingleDataProcessor<EntitySlime, Integer, MutableBoundedValue<Integer>, SlimeData, ImmutableSlimeData> {
    public SlimeDataProcessor() {
        super(EntitySlime.class, Keys.SLIME_SIZE);
    }

    @Override
    protected boolean set(EntitySlime entity, Integer value) {
        ((EntitySlimeAccessor)entity).accessor$setSlimeSize(value + 1, false);
        return true;
    }

    @Override
    protected Optional<Integer> getVal(EntitySlime entity) {
        return Optional.of(entity.func_70809_q() - 1);
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer actualValue) {
        return SpongeValueFactory.boundedBuilder(Keys.SLIME_SIZE).comparator(Constants.Functional.intComparator()).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue(actualValue).build();
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    protected SlimeData createManipulator() {
        return new SpongeSlimeData(0);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

