/*
 * Decompiled with CFR 0.152.
 */
package de.androidpit.colorthief;

import de.androidpit.colorthief.MMCQ;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Arrays;

public class ColorThief {
    private static final int DEFAULT_QUALITY = 10;
    private static final boolean DEFAULT_IGNORE_WHITE = true;

    public static int[] getColor(BufferedImage sourceImage) {
        int[][] palette = ColorThief.getPalette(sourceImage, 5);
        if (palette == null) {
            return null;
        }
        int[] dominantColor = palette[0];
        return dominantColor;
    }

    public static int[] getColor(BufferedImage sourceImage, int quality, boolean ignoreWhite) {
        int[][] palette = ColorThief.getPalette(sourceImage, 5, quality, ignoreWhite);
        if (palette == null) {
            return null;
        }
        int[] dominantColor = palette[0];
        return dominantColor;
    }

    public static int[][] getPalette(BufferedImage sourceImage, int colorCount) {
        MMCQ.CMap cmap = ColorThief.getColorMap(sourceImage, colorCount);
        if (cmap == null) {
            return null;
        }
        return cmap.palette();
    }

    public static int[][] getPalette(BufferedImage sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        MMCQ.CMap cmap = ColorThief.getColorMap(sourceImage, colorCount, quality, ignoreWhite);
        if (cmap == null) {
            return null;
        }
        return cmap.palette();
    }

    public static MMCQ.CMap getColorMap(BufferedImage sourceImage, int colorCount) {
        return ColorThief.getColorMap(sourceImage, colorCount, 10, true);
    }

    public static MMCQ.CMap getColorMap(BufferedImage sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        int[][] pixelArray;
        switch (sourceImage.getType()) {
            case 5: 
            case 6: {
                pixelArray = ColorThief.getPixelsFast(sourceImage, quality, ignoreWhite);
                break;
            }
            default: {
                pixelArray = ColorThief.getPixelsSlow(sourceImage, quality, ignoreWhite);
            }
        }
        MMCQ.CMap cmap = MMCQ.quantize(pixelArray, colorCount);
        return cmap;
    }

    private static int[][] getPixelsFast(BufferedImage sourceImage, int quality, boolean ignoreWhite) {
        int colorDepth;
        DataBufferByte imageData = (DataBufferByte)sourceImage.getRaster().getDataBuffer();
        byte[] pixels = imageData.getData();
        int pixelCount = sourceImage.getWidth() * sourceImage.getHeight();
        int type = sourceImage.getType();
        switch (type) {
            case 5: {
                colorDepth = 3;
                break;
            }
            case 6: {
                colorDepth = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type: " + type);
            }
        }
        int expectedDataLength = pixelCount * colorDepth;
        if (expectedDataLength != pixels.length) {
            throw new IllegalArgumentException("(expectedDataLength = " + expectedDataLength + ") != (pixels.length = " + pixels.length + ")");
        }
        int numRegardedPixels = (pixelCount + quality - 1) / quality;
        int numUsedPixels = 0;
        int[][] pixelArray = new int[numRegardedPixels][];
        switch (type) {
            case 5: {
                for (int i = 0; i < pixelCount; i += quality) {
                    int offset = i * 3;
                    int b = pixels[offset] & 0xFF;
                    int g = pixels[offset + 1] & 0xFF;
                    int r = pixels[offset + 2] & 0xFF;
                    if (ignoreWhite && r > 250 && g > 250 && b > 250) continue;
                    pixelArray[numUsedPixels] = new int[]{r, g, b};
                    ++numUsedPixels;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < pixelCount; i += quality) {
                    int offset = i * 4;
                    int a = pixels[offset] & 0xFF;
                    int b = pixels[offset + 1] & 0xFF;
                    int g = pixels[offset + 2] & 0xFF;
                    int r = pixels[offset + 3] & 0xFF;
                    if (a < 125 || ignoreWhite && r > 250 && g > 250 && b > 250) continue;
                    pixelArray[numUsedPixels] = new int[]{r, g, b};
                    ++numUsedPixels;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type: " + type);
            }
        }
        return (int[][])Arrays.copyOfRange(pixelArray, 0, numUsedPixels);
    }

    private static int[][] getPixelsSlow(BufferedImage sourceImage, int quality, boolean ignoreWhite) {
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        int pixelCount = width * height;
        int numRegardedPixels = (pixelCount + quality - 1) / quality;
        int numUsedPixels = 0;
        int[][] res = new int[numRegardedPixels][];
        for (int i = 0; i < pixelCount; i += quality) {
            int row = i / width;
            int col = i % width;
            int rgb = sourceImage.getRGB(col, row);
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            if (ignoreWhite && r > 250 && r > 250 && r > 250) continue;
            res[numUsedPixels] = new int[]{r, g, b};
            ++numUsedPixels;
        }
        return (int[][])Arrays.copyOfRange(res, 0, numUsedPixels);
    }
}

