/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public abstract class CustomAreaOrientedBlock<T extends WorkingAreaElectricMachine>
extends CustomOrientedBlock {
    private int maxWidth;
    private int height;
    private boolean acceptsRangeAddon;
    private RangeType type;

    public CustomAreaOrientedBlock(String registryName, Class<T> teClass, Material material, int energyForWork, int energyRate, RangeType type, int maxWidth, int height, boolean acceptsRangeAddon) {
        super(registryName, teClass, material, energyForWork, energyRate);
        this.maxWidth = maxWidth;
        this.height = height;
        this.acceptsRangeAddon = acceptsRangeAddon;
        this.type = type;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getHeight() {
        return this.height;
    }

    public RangeType getType() {
        return this.type;
    }

    public boolean isAcceptsRangeAddon() {
        return this.acceptsRangeAddon;
    }

    @Override
    public List<String> getTooltip(ItemStack stack) {
        List<String> tooltips = super.getTooltip(stack);
        if (this.acceptsRangeAddon) {
            tooltips.add(new TextComponentTranslation("text.industrialforegoing.tooltip.accepts_range_addons", new Object[0]).func_150254_d() + TextFormatting.GRAY + " (" + new TextComponentTranslation("text.industrialforegoing.tooltip.max_tier", new Object[0]).func_150254_d() + TextFormatting.GRAY + " " + this.getMaxWidth() + ")");
        } else {
            tooltips.add(new TextComponentTranslation("text.industrialforegoing.tooltip.range", new Object[0]).func_150254_d().replace("{0}", "" + (this.maxWidth * 2 + 1)).replace("{1}", this.height + 1 + ""));
        }
        return tooltips;
    }

    public static enum RangeType {
        FRONT{

            @Override
            public AxisAlignedBB getArea(BlockPos pos, int width, int height, EnumFacing f) {
                return WorkUtils.generateBlockSizeBox(pos).func_186670_a(new BlockPos(0, 0, 0).func_177967_a(f.func_176734_d(), width + 1)).func_72314_b((double)width, 0.0, (double)width).func_186666_e((double)(pos.func_177956_o() + 1 + height));
            }
        }
        ,
        UP{

            @Override
            public AxisAlignedBB getArea(BlockPos pos, int width, int height, EnumFacing f) {
                return WorkUtils.generateBlockSizeBox(pos).func_72317_d(0.0, 1.0, 0.0).func_72314_b((double)width, (double)height, (double)width);
            }
        };


        public abstract AxisAlignedBB getArea(BlockPos var1, int var2, int var3, EnumFacing var4);
    }
}

