/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.registry;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import tinker_io.handler.SmartOutputRecipeHandler;
import tinker_io.registry.MeltingRecipeRegister;

public class SmartOutputRecipeReigster {
    public static void register() {
        SmartOutputRecipeReigster.registerPureMetal();
    }

    private static void registerPureMetal() {
        MeltingRecipeRegister.customMeltingRecipes.forEach(recipe -> {
            FluidStack fluidStack = recipe.getResult();
            ItemStack output = SmartOutputRecipeReigster.getOutput(fluidStack);
            if (output != null) {
                SmartOutputRecipeHandler.registerSmartOutputCasting(output, TinkerSmeltery.castIngot, fluidStack);
            }
        });
    }

    private static ItemStack getOutput(FluidStack stack) {
        ItemStack oreStack;
        if (stack == null) {
            return null;
        }
        NBTTagCompound nbt = stack.tag;
        ItemStack resultStack = null;
        if (nbt != null && (oreStack = SmartOutputRecipeReigster.getItemByOreDic(nbt.func_74779_i("oreDict"))) != null) {
            resultStack = FurnaceRecipes.func_77602_a().func_151395_a(oreStack);
        }
        return resultStack;
    }

    private static ItemStack getItemByOreDic(String oreDic) {
        NonNullList oreStack = OreDictionary.getOres((String)oreDic);
        ItemStack result = null;
        if (!oreStack.isEmpty()) {
            result = (ItemStack)oreStack.get(0);
        }
        return result;
    }
}

