/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.messaging.chat;

import com.google.common.base.Preconditions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.messaging.chat.AllianceMessageChannel;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.AbstractMutableMessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;

public class AllianceMessageChannelImpl
extends AbstractMutableMessageChannel
implements AllianceMessageChannel {
    private final Set<Faction> factions;

    public static AllianceMessageChannelImpl forFaction(Faction faction) {
        Preconditions.checkNotNull((Object)faction);
        FactionLogic factionLogic = EagleFactionsPlugin.getPlugin().getFactionLogic();
        HashSet<Faction> receivers = new HashSet<Faction>();
        receivers.add(faction);
        receivers.addAll(faction.getAlliances().stream().map(factionLogic::getFactionByName).filter(Objects::nonNull).collect(Collectors.toList()));
        return new AllianceMessageChannelImpl(receivers);
    }

    public static AllianceMessageChannelImpl forPlayer(Player player) {
        Preconditions.checkNotNull((Object)player);
        Optional<Faction> optionalFaction = EagleFactionsPlugin.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalFaction.isPresent()) {
            throw new IllegalArgumentException("Player must belong to a faction!");
        }
        return AllianceMessageChannelImpl.forFaction(optionalFaction.get());
    }

    public AllianceMessageChannelImpl(Set<Faction> factions) {
        this.factions = Collections.unmodifiableSet(factions);
        this.getReceivers();
    }

    private void getReceivers() {
        ArrayList onlinePlayers = new ArrayList(Sponge.getServer().getOnlinePlayers());
        for (Player player : onlinePlayers) {
            for (Faction faction : this.factions) {
                if (!faction.containsPlayer(player.getUniqueId())) continue;
                super.addMember((MessageReceiver)player);
            }
        }
    }

    @Override
    public Set<Faction> getFactions() {
        return this.factions;
    }
}

