/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.progress;

import alexiil.mc.mod.load.ModLoadingListener;
import alexiil.mc.mod.load.progress.ProgressSectionInfo;
import alexiil.mc.mod.load.progress.SingleProgressBarTracker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.Loader;

public class LongTermProgressTracker {
    public final String[] modIds;
    public final ProgressSectionInfo[] infos;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static LongTermProgressTracker load() {
        File file = Loader.instance().getConfigDir();
        if (!(file = new File(file, "customloadingscreen_timings.nbt")).isFile()) return null;
        try (FileInputStream fis = new FileInputStream(file);){
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)fis);
            LongTermProgressTracker longTermProgressTracker = new LongTermProgressTracker(nbt);
            return longTermProgressTracker;
        }
        catch (IOException io) {
            io.printStackTrace();
            return null;
        }
    }

    public static void save(List<ProgressSectionInfo> infos) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList modList = new NBTTagList();
        for (String modId : ModLoadingListener.modIds) {
            modList.func_74742_a((NBTBase)new NBTTagString(modId));
        }
        nbt.func_74782_a("mods", (NBTBase)modList);
        int[] ids = new int[infos.size()];
        int[] timings = new int[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ProgressSectionInfo info = infos.get(i);
            int id = 0;
            if (info.modState != null) {
                id |= 1;
                id |= info.modState.ordinal() << 1;
                id |= ModLoadingListener.modIds.indexOf(info.modId) << 5;
            } else {
                id |= info.reloadPart.ordinal() << 1;
            }
            ids[i] = id;
            timings[i] = (int)info.time;
        }
        nbt.func_74783_a("ids", ids);
        nbt.func_74783_a("timings", timings);
        File file = Loader.instance().getConfigDir();
        file = new File(file, "customloadingscreen_timings.nbt");
        try (FileOutputStream fos = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fos);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    private LongTermProgressTracker(NBTTagCompound nbt) throws IOException {
        int[] timings;
        NBTTagList list = nbt.func_150295_c("mods", 8);
        this.modIds = new String[list.func_74745_c()];
        if (this.modIds.length == 0) {
            throw new IOException("0 mods isn't right!");
        }
        for (int i = 0; i < this.modIds.length; ++i) {
            this.modIds[i] = list.func_150307_f(i);
        }
        int[] ids = nbt.func_74759_k("ids");
        if (ids.length != (timings = nbt.func_74759_k("timings")).length || ids.length == 0) {
            throw new IOException("wrong lengths!");
        }
        this.infos = new ProgressSectionInfo[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            int stage;
            int id = ids[i];
            int time = timings[i];
            if ((id & 1) == 1) {
                stage = id >> 1 & 0xF;
                if (stage >= ModLoadingListener.LoaderStage.values().length) {
                    throw new IOException("Index out of bounds");
                }
                ModLoadingListener.LoaderStage loaderStage = ModLoadingListener.LoaderStage.values()[stage];
                int modIndex = id >>> 5;
                if (modIndex < 0 || modIndex >= this.modIds.length) {
                    throw new IOException("Index out of bounds");
                }
                String modId = this.modIds[modIndex];
                this.infos[i] = new ProgressSectionInfo(loaderStage, modId, time);
                continue;
            }
            stage = id >>> 1;
            if (stage >= SingleProgressBarTracker.ReloadPart.values().length) {
                throw new IOException("Index out of bounds");
            }
            SingleProgressBarTracker.ReloadPart reloadPart = SingleProgressBarTracker.ReloadPart.values()[stage];
            this.infos[i] = new ProgressSectionInfo(reloadPart, time);
        }
    }
}

