/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json.serial;

import alexiil.mc.mod.load.json.ConfigManager;
import alexiil.mc.mod.load.json.JsonAction;
import alexiil.mc.mod.load.json.JsonConfig;
import alexiil.mc.mod.load.json.JsonFactory;
import alexiil.mc.mod.load.json.JsonRenderingPart;
import alexiil.mc.mod.load.json.JsonVariable;
import alexiil.mc.mod.load.json.serial.IThrowingDeserialiser;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.JsonUtils;

public enum ConfigDeserialiser implements IThrowingDeserialiser<JsonConfig>
{
    INSTANCE;


    @Override
    public JsonConfig deserialize0(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws InvalidExpressionException {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            JsonConfig parent = obj.has("parent") ? (JsonConfig)JsonUtils.func_188174_a((JsonObject)obj, (String)"parent", (JsonDeserializationContext)context, JsonConfig.class) : null;
            JsonRenderingPart[] renders = (JsonRenderingPart[])JsonUtils.func_188174_a((JsonObject)obj, (String)"renders", (JsonDeserializationContext)context, JsonRenderingPart[].class);
            JsonFactory[] factories = (JsonFactory[])JsonUtils.func_188174_a((JsonObject)obj, (String)"factories", (JsonDeserializationContext)context, JsonFactory[].class);
            JsonAction[] actions = (JsonAction[])JsonUtils.func_188174_a((JsonObject)obj, (String)"actions", (JsonDeserializationContext)context, JsonAction[].class);
            JsonVariable[] constants = obj.has("constants") ? (JsonVariable[])JsonUtils.func_188174_a((JsonObject)obj, (String)"constants", (JsonDeserializationContext)context, JsonVariable.JsonConstant[].class) : new JsonVariable[]{};
            JsonVariable[] variables = obj.has("variables") ? (JsonVariable[])JsonUtils.func_188174_a((JsonObject)obj, (String)"variables", (JsonDeserializationContext)context, JsonVariable[].class) : new JsonVariable[]{};
            ArrayList<String[]> functions = new ArrayList<String[]>();
            if (obj.has("functions")) {
                ConfigDeserialiser.deserializeFunctions(obj.get("functions"), functions);
            }
            JsonConfig cfg = new JsonConfig(parent, renders, (String[][])functions.toArray((T[])new String[0][]), factories, actions, constants, variables);
            cfg.setSource((JsonElement)obj);
            return cfg;
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive prim = json.getAsJsonPrimitive();
            if (prim.isString()) {
                return ConfigManager.getAsConfig(prim.getAsString());
            }
            throw new JsonSyntaxException("Expected an object or a string, found " + prim);
        }
        throw new JsonSyntaxException("Expected an object or a string, found " + json);
    }

    private static void deserializeFunctions(JsonElement json, List<String[]> functions) {
        if (!json.isJsonObject()) {
            return;
        }
        JsonObject obj = json.getAsJsonObject();
        Set entrySet = obj.entrySet();
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            JsonElement jvalue = (JsonElement)entry.getValue();
            String value = jvalue.getAsString();
            functions.add(new String[]{name, value});
        }
    }
}

