/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.jarrelocator;

import me.lucko.jarrelocator.RelocatingRemapper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

final class RelocatingClassVisitor
extends ClassRemapper {
    private final String packageName;

    RelocatingClassVisitor(ClassWriter writer, RelocatingRemapper remapper, String name) {
        super((ClassVisitor)writer, (Remapper)remapper);
        this.packageName = name.substring(0, name.lastIndexOf(47) + 1);
    }

    public void visitSource(String source, String debug) {
        if (source == null) {
            super.visitSource(null, debug);
            return;
        }
        String name = this.packageName + source;
        String mappedName = this.remapper.map(name);
        String mappedFileName = mappedName.substring(mappedName.lastIndexOf(47) + 1);
        super.visitSource(mappedFileName, debug);
    }
}

