/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasItem;
import mekanism.common.MekanismFluids;
import mekanism.common.recipe.ingredients.IMekanismIngredient;
import mekanism.common.recipe.ingredients.ItemStackMekIngredient;
import mekanism.common.recipe.ingredients.OredictMekIngredient;
import mekanism.common.tier.GasTankTier;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class GasConversionHandler {
    private static final Map<Gas, List<IMekanismIngredient<ItemStack>>> gasToIngredients = new HashMap<Gas, List<IMekanismIngredient<ItemStack>>>();
    private static final Map<IMekanismIngredient<ItemStack>, GasStack> ingredientToGas = new HashMap<IMekanismIngredient<ItemStack>, GasStack>();

    public static void addDefaultGasMappings() {
        GasConversionHandler.addGasMapping(new ItemStack(Items.field_151145_ak), MekanismFluids.Oxygen, 10);
        GasConversionHandler.addGasMapping("dustSulfur", MekanismFluids.SulfuricAcid, 2);
        GasConversionHandler.addGasMapping("dustSalt", MekanismFluids.HydrogenChloride, 2);
        GasConversionHandler.addGasMapping("ingotOsmium", MekanismFluids.LiquidOsmium, 200);
        GasConversionHandler.addGasMapping("blockOsmium", MekanismFluids.LiquidOsmium, 1800);
    }

    public static boolean addGasMapping(@Nonnull ItemStack stack, @Nonnull Gas gas, int amount) {
        return GasConversionHandler.addGasMapping(new ItemStackMekIngredient(stack), new GasStack(gas, amount));
    }

    public static boolean addGasMapping(@Nonnull String oreDict, @Nonnull Gas gas, int amount) {
        return GasConversionHandler.addGasMapping(new OredictMekIngredient(oreDict), new GasStack(gas, amount));
    }

    public static boolean addGasMapping(@Nonnull IMekanismIngredient<ItemStack> ingredient, @Nonnull GasStack gasStack) {
        Gas gas = gasStack.getGas();
        if (gas == null || gasStack.amount <= 0) {
            return false;
        }
        List ingredients = gasToIngredients.computeIfAbsent(gas, k -> new ArrayList());
        ingredients.add(ingredient);
        return ingredientToGas.put(ingredient, gasStack) == null;
    }

    public static int removeGasMapping(@Nonnull IMekanismIngredient<ItemStack> ingredient, @Nonnull GasStack gasStack) {
        Gas gas = gasStack.getGas();
        if (gas != null && gasStack.amount > 0 && gasToIngredients.containsKey(gas)) {
            List<IMekanismIngredient<ItemStack>> ingredients = gasToIngredients.get(gas);
            ArrayList<IMekanismIngredient<ItemStack>> toRemove = new ArrayList<IMekanismIngredient<ItemStack>>();
            for (IMekanismIngredient<ItemStack> stored : ingredients) {
                if (!stored.equals(ingredient)) continue;
                toRemove.add(stored);
                ingredientToGas.remove(stored);
            }
            if (ingredients.size() == toRemove.size()) {
                gasToIngredients.remove(gas);
            } else {
                ingredients.removeAll(toRemove);
            }
            return toRemove.size();
        }
        return 0;
    }

    public static void removeAllGasMappings() {
        gasToIngredients.clear();
        ingredientToGas.clear();
    }

    @Nullable
    public static GasStack getItemGas(ItemStack itemStack, GasTank gasTank, Predicate<Gas> isValidGas) {
        return GasConversionHandler.getItemGas(itemStack, gasTank.getNeeded(), (Gas gas, Integer quantity) -> {
            if (gas != null && gasTank.canReceive((Gas)gas) && isValidGas.test((Gas)gas)) {
                return new GasStack((Gas)gas, (int)quantity);
            }
            return null;
        });
    }

    @Nullable
    public static GasStack getItemGas(ItemStack itemStack, int needed, BiFunction<Gas, Integer, GasStack> getIfValid) {
        GasStack gasStack;
        int amount;
        IGasItem item;
        GasStack gas;
        if (itemStack.func_77973_b() instanceof IGasItem && (gas = (item = (IGasItem)itemStack.func_77973_b()).getGas(itemStack)) != null && item.canProvideGas(itemStack, gas.getGas()) && (amount = Math.min(needed, Math.min(gas.amount, item.getRate(itemStack)))) > 0 && (gasStack = getIfValid.apply(gas.getGas(), amount)) != null) {
            return gasStack;
        }
        for (Map.Entry<IMekanismIngredient<ItemStack>, GasStack> entry : ingredientToGas.entrySet()) {
            GasStack gasStack2;
            if (!entry.getKey().contains(itemStack) || (gasStack2 = getIfValid.apply(entry.getValue().getGas(), entry.getValue().amount)) == null) continue;
            return gasStack2;
        }
        return null;
    }

    public static List<ItemStack> getStacksForGas(Gas type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(MekanismUtils.getFullGasTank(GasTankTier.BASIC, type));
        List<IMekanismIngredient<ItemStack>> ingredients = gasToIngredients.get(type);
        if (ingredients == null) {
            return stacks;
        }
        for (IMekanismIngredient<ItemStack> ingredient : ingredients) {
            stacks.addAll(ingredient.getMatching());
        }
        return stacks;
    }
}

