/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import cubex2.cs4.api.WrappedItemStack;
import cubex2.cs4.plugins.vanilla.WrappedItemStackImpl;
import java.lang.reflect.Type;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

class WrappedItemStackDeserializer
implements JsonDeserializer<WrappedItemStack> {
    private static final String WILDCARD_STRING = "all";

    WrappedItemStackDeserializer() {
    }

    public WrappedItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            return this.fromString(json, context);
        }
        return this.fromObject(json, context);
    }

    private WrappedItemStack fromString(JsonElement json, JsonDeserializationContext context) {
        JsonPrimitive primitive = json.getAsJsonPrimitive();
        if (primitive.isString()) {
            Pair<String, Integer> pair = this.parseItemPart(primitive.getAsString());
            WrappedItemStackImpl stack = new WrappedItemStackImpl();
            stack.item = (ResourceLocation)context.deserialize((JsonElement)new JsonPrimitive((String)pair.getLeft()), ResourceLocation.class);
            stack.metadata = (Integer)pair.getRight();
            return stack;
        }
        throw new JsonParseException("Invalid element for stack.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WrappedItemStack fromObject(JsonElement json, JsonDeserializationContext context) {
        WrappedItemStackImpl stack = new WrappedItemStackImpl();
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("item")) {
            JsonElement element = jsonObject.get("item");
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                Pair<String, Integer> pair = this.parseItemPart(element.getAsString());
                element = new JsonPrimitive((String)pair.getLeft());
                stack.metadata = (Integer)pair.getRight();
            }
            stack.item = (ResourceLocation)context.deserialize(element, ResourceLocation.class);
        }
        if (jsonObject.has("amount")) {
            stack.amount = jsonObject.get("amount").getAsInt();
        }
        if (jsonObject.has("metadata")) {
            JsonPrimitive metadata = jsonObject.getAsJsonPrimitive("metadata");
            if (metadata.isString()) {
                if (!metadata.getAsString().toLowerCase().equals(WILDCARD_STRING)) throw new JsonParseException("Invalid value for metadata: " + metadata.getAsString());
                stack.metadata = Short.MAX_VALUE;
            } else {
                stack.metadata = metadata.getAsInt();
            }
        }
        if (!jsonObject.has("nbt")) return stack;
        stack.nbt = (NBTTagCompound)context.deserialize(jsonObject.get("nbt"), NBTTagCompound.class);
        return stack;
    }

    private Pair<String, Integer> parseItemPart(String input) {
        int meta = 0;
        if (input.contains("@")) {
            String metaPart = input.substring(input.lastIndexOf(64) + 1);
            input = input.substring(0, input.lastIndexOf(64));
            meta = metaPart.equalsIgnoreCase(WILDCARD_STRING) ? Short.MAX_VALUE : Integer.parseInt(metaPart);
        }
        return Pair.of((Object)input, (Object)meta);
    }
}

