/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.climate;

import forestry.api.climate.ClimateType;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import java.util.function.Function;

public interface IClimateState {
    public float getTemperature();

    default public EnumTemperature getTemperatureEnum() {
        return EnumTemperature.getFromValue(this.getTemperature());
    }

    public float getHumidity();

    default public EnumHumidity getHumidityEnum() {
        return EnumHumidity.getFromValue(this.getHumidity());
    }

    default public float getClimate(ClimateType type) {
        return type == ClimateType.HUMIDITY ? this.getHumidity() : this.getTemperature();
    }

    public IClimateState addTemperature(float var1);

    public IClimateState addHumidity(float var1);

    public IClimateState add(IClimateState var1);

    default public IClimateState add(ClimateType type, float value) {
        return type == ClimateType.HUMIDITY ? this.addHumidity(value) : this.addTemperature(value);
    }

    public IClimateState setTemperature(float var1);

    public IClimateState setHumidity(float var1);

    public IClimateState setClimate(float var1, float var2);

    default public IClimateState setClimate(ClimateType type, float value) {
        return type == ClimateType.HUMIDITY ? this.setHumidity(value) : this.setTemperature(value);
    }

    public IClimateState multiply(double var1);

    default public IClimateState subtractTemperature(float value) {
        return this.addTemperature(-value);
    }

    default public IClimateState subtractHumidity(float value) {
        return this.addHumidity(-value);
    }

    public IClimateState subtract(IClimateState var1);

    default public IClimateState subtract(ClimateType type, float value) {
        return type == ClimateType.HUMIDITY ? this.subtractHumidity(value) : this.subtractTemperature(value);
    }

    public IClimateState map(Function<Float, Float> var1);

    public IClimateState copy(boolean var1);

    public IClimateState copy();

    public IClimateState toMutable();

    public IClimateState toImmutable();

    public boolean isPresent();

    public boolean isMutable();

    public boolean isClamped();
}

