/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.gameobject;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class BlockIdentity {
    public static final BlockIdentity AIR = new BlockIdentity(Blocks.field_150350_a);
    private final Block block;
    private final int meta;

    public static BlockIdentity getForState(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150350_a ? AIR : new BlockIdentity(block, block.func_176201_c(state));
    }

    public BlockIdentity(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public BlockIdentity(Block block) {
        this(block, -1);
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public boolean isAir() {
        return this.block == Blocks.field_150350_a;
    }

    public IBlockState createState() {
        return this.meta == -1 ? this.block.func_176223_P() : this.block.func_176203_a(this.meta);
    }

    public boolean matches(IBlockState state) {
        if (this.isAir()) {
            return state.func_177230_c() == Blocks.field_150350_a;
        }
        return state.func_177230_c() == this.block && (this.meta == -1 || this.block.func_176201_c(state) == this.meta);
    }

    public int hashCode() {
        if (this.isAir()) {
            return 0;
        }
        return this.block.hashCode() * 523 ^ this.meta;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockIdentity)) {
            return false;
        }
        BlockIdentity o = (BlockIdentity)obj;
        return this.isAir() && o.isAir() || this.block == o.block && this.meta == o.meta;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.block.getRegistryName());
        if (this.meta != -1) {
            sb.append(":").append(this.meta);
        }
        return sb.toString();
    }
}

