/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.gui.component;

import io.github.phantamanta44.libnine.client.gui.component.GuiComponent;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;

public class GuiComponentManager {
    private final GuiScreen gui;
    private final ArrayList<ComponentState> comps;

    public GuiComponentManager(GuiScreen gui) {
        this.gui = gui;
        this.comps = new ArrayList();
    }

    public void register(GuiComponent comp) {
        comp.setGui(this.gui);
        this.comps.add(new ComponentState(comp));
    }

    public void draw(float partialTicks, int mX, int mY) {
        this.comps.forEach(c -> c.drawAndUpdate(partialTicks, mX, mY));
        this.comps.forEach(c -> c.drawTooltip(partialTicks, mX, mY));
    }

    public boolean handleMouseClick(int mX, int mY, int button) {
        boolean passThrough = true;
        for (ComponentState comp : this.comps) {
            if (!comp.handleMouseClick(mX, mY, button)) continue;
            passThrough = false;
        }
        return passThrough;
    }

    public boolean handleMouseDrag(int mX, int mY, int button, long dragTime) {
        boolean passThrough = true;
        for (ComponentState comp : this.comps) {
            if (!comp.handleMouseDrag(mX, mY, button, dragTime)) continue;
            passThrough = false;
        }
        return passThrough;
    }

    public boolean handleKeyTyped(char typed, int keyCode) {
        boolean passThrough = true;
        for (ComponentState comp : this.comps) {
            if (!comp.handleKeyTyped(typed, keyCode)) continue;
            passThrough = false;
        }
        return passThrough;
    }

    private static class ComponentState {
        private final GuiComponent comp;
        private boolean mouseOver;

        ComponentState(GuiComponent comp) {
            this.comp = comp;
            this.mouseOver = false;
        }

        void drawAndUpdate(float partialTicks, int mX, int mY) {
            this.mouseOver = this.comp.isMouseOver(mX, mY);
            this.comp.render(partialTicks, mX, mY, this.mouseOver);
        }

        void drawTooltip(float partialTicks, int mX, int mY) {
            if (this.mouseOver) {
                this.comp.renderTooltip(partialTicks, mX, mY);
            }
        }

        boolean handleMouseClick(int mX, int mY, int button) {
            return this.comp.onClick(mX, mY, button, this.mouseOver);
        }

        boolean handleMouseDrag(int mX, int mY, int button, long dragTime) {
            return this.comp.onDrag(mX, mY, button, dragTime, this.mouseOver);
        }

        boolean handleKeyTyped(char typed, int keyCode) {
            return this.comp.onKeyPress(keyCode, typed);
        }
    }
}

