/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.capability.impl;

import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import io.github.phantamanta44.libnine.util.function.IInventoryObserver;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class L9AspectSlot
implements IItemHandlerModifiable,
ISerializable {
    private ItemStack stack = ItemStack.field_190927_a;
    @Nullable
    private final Predicate<ItemStack> pred;

    public L9AspectSlot(@Nullable Predicate<ItemStack> pred) {
        this.pred = pred;
    }

    public L9AspectSlot() {
        this(null);
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            throw new IndexOutOfBoundsException("Not in bounds of single-slot inventory: " + slot);
        }
        return this.getStackInSlot();
    }

    public ItemStack getStackInSlot() {
        return this.stack;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (slot != 0) {
            throw new IndexOutOfBoundsException("Not in bounds of single-slot inventory: " + slot);
        }
        this.setStackInSlot(stack);
    }

    public void setStackInSlot(ItemStack stack) {
        this.stack = stack;
        int slotLimit = this.getSlotLimit();
        if (stack.func_190916_E() > slotLimit) {
            stack.func_190920_e(slotLimit);
        }
    }

    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot != 0) {
            throw new IndexOutOfBoundsException("Not in bounds of single-slot inventory: " + slot);
        }
        return this.insertItem(stack, simulate);
    }

    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.pred != null && !this.pred.test(stack)) {
            return stack;
        }
        if (this.getStackInSlot().func_190926_b()) {
            int toTransfer = Math.min(stack.func_190916_E(), this.getSlotLimit());
            if (!simulate) {
                this.setStackInSlot(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)toTransfer));
            }
            return toTransfer == stack.func_190916_E() ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - toTransfer));
        }
        int maxStackSize = Math.min(this.getStackInSlot().func_77976_d(), this.getSlotLimit());
        if (this.getStackInSlot().func_190916_E() >= maxStackSize || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStackInSlot(), (ItemStack)stack)) {
            return stack;
        }
        int toTransfer = Math.min(stack.func_190916_E(), maxStackSize - this.getStackInSlot().func_190916_E());
        if (!simulate) {
            this.getStackInSlot().func_190917_f(toTransfer);
        }
        return toTransfer == stack.func_190916_E() ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - toTransfer));
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0) {
            throw new IndexOutOfBoundsException("Not in bounds of single-slot inventory: " + slot);
        }
        return this.extractItem(amount, simulate);
    }

    public ItemStack extractItem(int amount, boolean simulate) {
        if (amount == 0 || this.getStackInSlot().func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toTransfer = Math.min(amount, this.getStackInSlot().func_190916_E());
        ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)this.getStackInSlot(), (int)toTransfer);
        if (!simulate) {
            if (this.getStackInSlot().func_190916_E() == toTransfer) {
                this.setStackInSlot(ItemStack.field_190927_a);
            } else {
                this.getStackInSlot().func_190918_g(toTransfer);
            }
        }
        return result;
    }

    public int getSlotLimit(int slot) {
        return this.getSlotLimit();
    }

    public int getSlotLimit() {
        return 64;
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        if (this.stack.func_190926_b()) {
            data.writeShort((short)-1);
        } else {
            data.writeItemStack(this.stack);
        }
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        if (data.readShort() == -1) {
            this.setStackInSlot(ItemStack.field_190927_a);
        } else {
            this.setStackInSlot(data.backUp(2).readItemStack());
        }
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        NBTTagCompound itemTag = new NBTTagCompound();
        if (this.stack.func_190926_b()) {
            itemTag.func_74757_a("Empty", true);
        } else {
            this.stack.func_77955_b(itemTag);
        }
        tag.func_74782_a("Item", (NBTBase)itemTag);
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        NBTTagCompound itemTag = tag.func_74775_l("Item");
        this.setStackInSlot(itemTag.func_74764_b("Empty") ? ItemStack.field_190927_a : new ItemStack(itemTag));
    }

    public static class Observable
    extends L9AspectSlot {
        private final IInventoryObserver observer;

        public Observable(@Nullable Predicate<ItemStack> pred, IInventoryObserver observer) {
            super(pred);
            this.observer = observer;
        }

        public Observable(IInventoryObserver observer) {
            this(null, observer);
        }

        @Override
        public void setStackInSlot(ItemStack stack) {
            ItemStack original = this.getStackInSlot().func_77946_l();
            super.setStackInSlot(stack);
            this.observer.onSlotChanged(0, original, this.getStackInSlot());
        }

        @Override
        public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
            if (simulate) {
                return super.insertItem(stack, true);
            }
            ItemStack original = this.getStackInSlot().func_77946_l();
            ItemStack result = super.insertItem(stack, false);
            if (result.func_190916_E() != stack.func_190916_E()) {
                this.observer.onSlotChanged(0, original, this.getStackInSlot());
            }
            return result;
        }

        @Override
        public ItemStack extractItem(int amount, boolean simulate) {
            if (simulate) {
                return super.extractItem(amount, true);
            }
            ItemStack original = this.getStackInSlot().func_77946_l();
            ItemStack result = super.extractItem(amount, false);
            if (!result.func_190926_b()) {
                this.observer.onSlotChanged(0, original, this.getStackInSlot());
            }
            return result;
        }
    }
}

