/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile.base;

import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.data.serialization.IDatum;
import io.github.phantamanta44.threng.tile.base.IActivable;
import io.github.phantamanta44.threng.tile.base.IDirectionable;
import io.github.phantamanta44.threng.tile.base.TilePowered;
import net.minecraft.util.EnumFacing;

public abstract class TileMachine
extends TilePowered
implements IActivable,
IDirectionable {
    @AutoSerialize
    private final IDatum<EnumFacing> frontFace = IDatum.of((Object)EnumFacing.NORTH);
    @AutoSerialize
    private final IDatum.OfInt work = IDatum.ofInt((int)0);
    private boolean couldWorkLastTick = false;
    private boolean working = false;
    private EnumFacing clientFace = EnumFacing.NORTH;

    public TileMachine(int energyBuffer) {
        super(energyBuffer);
    }

    protected void tick() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.canWork()) {
                int energyCost = this.getEnergyCost();
                if (this.energy.getQuantity() > energyCost) {
                    this.energy.draw(energyCost, true);
                    if (this.work.preincrement(this.getDeltaWork()) > this.getMaxWork()) {
                        this.work.setInt(0);
                        this.onWorkFinished();
                    }
                    this.working = true;
                    this.setDirty();
                } else {
                    this.working = false;
                }
                this.couldWorkLastTick = true;
            } else if (this.couldWorkLastTick) {
                this.couldWorkLastTick = false;
                if (!this.field_145850_b.field_72995_K) {
                    this.work.setInt(0);
                }
                this.working = false;
                this.setDirty();
            }
        }
    }

    protected abstract int getEnergyCost();

    protected abstract boolean canWork();

    protected abstract int getDeltaWork();

    protected abstract int getMaxWork();

    protected abstract void onWorkFinished();

    public int getWork() {
        return this.work.getInt();
    }

    protected void resetWork() {
        this.work.setInt(0);
    }

    public float getWorkFraction() {
        return Math.min((float)this.getWork() / (float)this.getMaxWork(), 1.0f);
    }

    @Override
    public boolean isActive() {
        return this.working;
    }

    @Override
    public EnumFacing getFrontFace() {
        return (EnumFacing)this.frontFace.get();
    }

    @Override
    public void setFrontFace(EnumFacing face) {
        this.frontFace.set((Object)face);
        this.setDirty();
    }

    public void serBytes(ByteUtils.Writer data) {
        super.serBytes(data);
        data.writeBool(this.working);
    }

    public void deserBytes(ByteUtils.Reader data) {
        EnumFacing front;
        super.deserBytes(data);
        boolean needsRenderUpdate = false;
        boolean nowWorking = data.readBool();
        if (this.working != nowWorking) {
            this.working = nowWorking;
            needsRenderUpdate = true;
        }
        if (this.clientFace != (front = (EnumFacing)this.frontFace.get())) {
            this.clientFace = front;
            needsRenderUpdate = true;
        }
        if (needsRenderUpdate) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }
}

