/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.client.gui;

import io.github.phantamanta44.libnine.client.gui.L9GuiContainer;
import io.github.phantamanta44.libnine.gui.L9Container;
import io.github.phantamanta44.libnine.util.render.GuiUtils;
import io.github.phantamanta44.threng.ThrEngConfig;
import io.github.phantamanta44.threng.client.gui.component.GuiComponentPageNav;
import io.github.phantamanta44.threng.client.gui.component.GuiComponentSearchBar;
import io.github.phantamanta44.threng.constant.ResConst;
import io.github.phantamanta44.threng.inventory.ContainerBigAssembler;
import io.github.phantamanta44.threng.inventory.slot.IDisplayModeSlot;
import io.github.phantamanta44.threng.tile.TileBigAssemblerCore;
import io.github.phantamanta44.threng.util.IPaginated;
import io.github.phantamanta44.threng.util.ISearchHost;
import io.github.phantamanta44.threng.util.ISearchable;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Mouse;

public class GuiBigAssembler
extends L9GuiContainer
implements IPaginated,
ISearchHost {
    private final ContainerBigAssembler cont;
    private int currentPage = 0;

    public GuiBigAssembler(ContainerBigAssembler cont) {
        super((L9Container)cont, ResConst.GUI_BIG_ASSEMBLER.getTexture(), 176, 217);
        this.cont = cont;
        for (int i = 1; i < cont.getPageCount(); ++i) {
            cont.getPage(i).setActive(false);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addComponent(new GuiComponentSearchBar(79, 4, 90, 12, this));
        this.addComponent(new GuiComponentPageNav(108, 93, this));
    }

    @Override
    public int getPageCount() {
        return this.cont.getPageCount();
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public void setPage(int pageNum) {
        this.cont.getPage(this.currentPage).setActive(false);
        this.currentPage = pageNum;
        this.cont.getPage(this.currentPage).setActive(true);
    }

    @Override
    public void setSearchQuery(@Nullable String query) {
        for (Slot slot : this.cont.field_75151_b) {
            if (!(slot instanceof ISearchable)) continue;
            ((ISearchable)slot).updateSearchQuery(query);
        }
    }

    public void drawForeground(float partialTicks, int mX, int mY) {
        TileBigAssemblerCore.IAssemblyJob job;
        int cpuCount;
        int jobCount;
        super.drawForeground(partialTicks, mX, mY);
        this.drawContainerName(I18n.func_135052_a((String)"threng.container.big_assembler", (Object[])new Object[0]));
        TileBigAssemblerCore tile = this.cont.getAssemblerCore();
        int work = tile.getWork();
        if (work > 0) {
            ResConst.GUI_BIG_ASSEMBLER_PROGRESS.drawPartial(36, 113, 0.0f, 0.0f, Math.min((float)work / (float)tile.getWorkPerJob(), 1.0f), 1.0f);
        }
        if ((jobCount = tile.getJobCount()) > 0) {
            ResConst.GUI_BIG_ASSEMBLER_QUEUE.drawPartial(58, 94, 0.0f, 1.0f - (float)jobCount / (float)ThrEngConfig.massAssembler.jobQueueSize, 1.0f, 1.0f);
        }
        if ((cpuCount = tile.getCpuCount()) > 0) {
            int maxEffectiveCpus = tile.getMaxEffectiveCpus();
            float cpuBar = cpuCount >= maxEffectiveCpus ? 1.0f : (float)(Math.log1p(cpuCount) / Math.log1p(maxEffectiveCpus));
            ResConst.GUI_BIG_ASSEMBLER_CPUS.drawPartial(64, 94, 0.0f, 1.0f - cpuBar, 1.0f, 1.0f);
        }
        if ((job = tile.getActiveJob()) != null) {
            int index = job.getJobIndex();
            IItemHandler craftBuf = tile.getCraftingBuffer();
            this.field_73735_i = 100.0f;
            this.field_146296_j.field_77023_b = 100.0f;
            RenderHelper.func_74520_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    this.drawStack(craftBuf.getStackInSlot(index * 9 + row * 3 + col), 15 + col * 18, 187 + row * 18);
                }
            }
            GlStateManager.func_179121_F();
            this.drawStack(job.getResult(), 36, 94);
            RenderHelper.func_74518_a();
            this.field_146296_j.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"threng.misc.tooltip.page_num", (Object[])new Object[]{this.currentPage + 1, this.getPageCount()}), 108, 108, 0x404040);
    }

    private void drawStack(ItemStack stack, int x, int y) {
        this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, stack, x, y);
        this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, null);
    }

    public void drawOverlay(float partialTicks, int mX, int mY) {
        TileBigAssemblerCore tile = this.cont.getAssemblerCore();
        if (GuiUtils.isMouseOver((int)35, (int)112, (int)18, (int)4, (int)mX, (int)mY)) {
            this.drawTooltip(I18n.func_135052_a((String)"threng.misc.tooltip.work_fraction", (Object[])new Object[]{tile.getWork(), tile.getWorkPerJob()}), mX, mY);
        } else if (GuiUtils.isMouseOver((int)57, (int)93, (int)5, (int)27, (int)mX, (int)mY)) {
            this.drawTooltip(I18n.func_135052_a((String)"threng.misc.tooltip.job_count", (Object[])new Object[]{tile.getJobCount(), ThrEngConfig.massAssembler.jobQueueSize}), mX, mY);
        } else if (GuiUtils.isMouseOver((int)63, (int)93, (int)5, (int)27, (int)mX, (int)mY)) {
            this.drawTooltip(Arrays.asList(I18n.func_135052_a((String)"threng.misc.tooltip.cpu_count", (Object[])new Object[]{tile.getCpuCount()}), I18n.func_135052_a((String)"threng.misc.tooltip.work_rate", (Object[])new Object[]{tile.getWorkRate()})), mX, mY);
        }
    }

    public void func_146977_a(Slot slot) {
        if (slot instanceof IDisplayModeSlot) {
            ((IDisplayModeSlot)slot).prepareDisplayMode();
        }
        super.func_146977_a(slot);
        if (slot instanceof ISearchable && !((ISearchable)slot).matchesQuery()) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179140_f();
            GuiBigAssembler.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)0x7F000000);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = Mouse.getEventDWheel();
        if (scroll < 0) {
            if (this.currentPage < this.cont.getPageCount() - 1) {
                this.setPage(this.currentPage + 1);
            }
        } else if (scroll > 0 && this.currentPage > 0) {
            this.setPage(this.currentPage - 1);
        }
    }
}

