/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.registry;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.base.conduit.registry.ConduitDefinition;
import crazypants.enderio.base.conduit.registry.ConduitTypeDefinition;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class ConduitBuilder {
    @Nonnull
    private State state = State.EMPTY;
    ConduitTypeDefinition network;
    private UUID networkUUID;
    @Nonnull
    private final NNList<UUID> networkAliases = new NNList();
    private Class<? extends IConduit> baseType;
    private Offset none = Offset.NONE;
    private Offset x = Offset.NONE;
    private Offset y = Offset.NONE;
    private Offset z = Offset.NONE;
    private boolean canConnectToAnything;
    private UUID conduitUUID;
    @Nonnull
    private final NNList<UUID> conduitAliases = new NNList();
    private Class<? extends IServerConduit> serverClass;
    private Class<? extends IClientConduit> clientClass;

    private ConduitBuilder() {
    }

    public static ConduitBuilder start() {
        return new ConduitBuilder();
    }

    public ConduitBuilder setUUID(@Nonnull UUID uuid) {
        this.checkState(this.state.acceptNetworkData || this.state.acceptConduitData);
        if (this.state.acceptNetworkData) {
            this.networkUUID = uuid;
            this.state = State.NETWORK;
        } else {
            this.conduitUUID = uuid;
            this.state = State.CONDUIT;
        }
        return this;
    }

    public ConduitBuilder setUUID(@Nonnull String uuid) {
        return this.setUUID(UUID.nameUUIDFromBytes(uuid.getBytes()));
    }

    public ConduitBuilder setUUID(@Nonnull Class<? extends IConduit> uuid) {
        return this.setUUID(uuid.getName());
    }

    public ConduitBuilder setUUID(@Nonnull ResourceLocation uuid) {
        return this.setUUID(uuid.toString());
    }

    public ConduitBuilder addAlias(@Nonnull UUID uuid) {
        this.checkState(this.state.acceptNetworkData || this.state.acceptConduitData);
        if (this.state.acceptNetworkData) {
            this.networkAliases.add((Object)uuid);
            this.state = State.NETWORK;
        } else {
            this.conduitAliases.add((Object)uuid);
            this.state = State.CONDUIT;
        }
        return this;
    }

    public ConduitBuilder addAlias(@Nonnull String uuid) {
        return this.addAlias(UUID.nameUUIDFromBytes(uuid.getBytes()));
    }

    public ConduitBuilder addAlias(@Nonnull Class<? extends IConduit> uuid) {
        return this.addAlias(uuid.getName());
    }

    public ConduitBuilder addAlias(@Nonnull ResourceLocation uuid) {
        return this.addAlias(uuid.toString());
    }

    public ConduitBuilder setClass(@Nonnull Class<? extends IConduit> clazz) {
        this.checkState(this.state.acceptNetworkData || this.state.acceptConduitData);
        if (this.state.acceptNetworkData) {
            this.baseType = clazz;
            this.state = State.NETWORK;
        } else {
            if (IServerConduit.class.isAssignableFrom(clazz)) {
                this.serverClass = clazz;
            }
            if (IClientConduit.class.isAssignableFrom(clazz)) {
                this.clientClass = clazz;
            }
            this.state = State.CONDUIT;
        }
        return this;
    }

    public ConduitBuilder setOffsets(@Nonnull Offset none, @Nonnull Offset x, @Nonnull Offset y, @Nonnull Offset z) {
        this.checkState(this.state.acceptNetworkData);
        this.none = none;
        this.x = x;
        this.y = y;
        this.z = z;
        this.state = State.NETWORK;
        return this;
    }

    public ConduitBuilder setCanConnectToAnything() {
        this.checkState(this.state.acceptNetworkData);
        this.canConnectToAnything = true;
        this.state = State.NETWORK;
        return this;
    }

    public ConduitBuilder build() {
        this.checkState(this.state.acceptNetworkBuild || this.state.acceptConduitBuild);
        if (this.state.acceptNetworkBuild) {
            Offset z2;
            Offset y2;
            Offset x2;
            Offset none2;
            Class<? extends IConduit> baseType2;
            UUID networkUUID2 = this.networkUUID;
            if (networkUUID2 != null && (baseType2 = this.baseType) != null && (none2 = this.none) != null && (x2 = this.x) != null && (y2 = this.y) != null && (z2 = this.z) != null) {
                this.network = new ConduitTypeDefinition(networkUUID2, baseType2, none2, x2, y2, z2, this.canConnectToAnything);
                this.network.getAliases().addAll(this.networkAliases);
                this.state = State.PRE_CONDUIT;
                return this;
            }
        } else {
            Class<? extends IClientConduit> clientClass2;
            Class<? extends IServerConduit> serverClass2;
            UUID conduitUUID2;
            ConduitTypeDefinition network2 = this.network;
            if (network2 != null && (conduitUUID2 = this.conduitUUID) != null && (serverClass2 = this.serverClass) != null && (clientClass2 = this.clientClass) != null) {
                new ConduitDefinition(network2, conduitUUID2, serverClass2, clientClass2).getAliases().addAll(this.conduitAliases);
                this.conduitUUID = null;
                this.conduitAliases.clear();
                this.serverClass = null;
                this.clientClass = null;
                this.state = State.POST_CONDUIT;
                return this;
            }
        }
        throw new RuntimeException("State error in Conduit Builder---data missing");
    }

    @Nonnull
    public ConduitTypeDefinition finish() {
        this.checkState(this.state.acceptFinalize);
        ConduitTypeDefinition network2 = this.network;
        if (network2 != null) {
            return network2;
        }
        throw new RuntimeException("State error in Conduit Builder---data missing");
    }

    private void checkState(boolean ok) {
        if (!ok) {
            throw new RuntimeException("State error in Conduit Builder (" + (Object)((Object)this.state) + ")");
        }
    }

    private static enum State {
        EMPTY(true, false, false, false, false),
        NETWORK(true, true, false, false, false),
        PRE_CONDUIT(false, false, true, false, false),
        CONDUIT(false, false, true, true, false),
        POST_CONDUIT(false, false, true, false, true);

        private final boolean acceptNetworkData;
        private final boolean acceptNetworkBuild;
        private final boolean acceptConduitData;
        private final boolean acceptConduitBuild;
        private final boolean acceptFinalize;

        private State(boolean acceptNetworkData, boolean acceptNetworkBuild, boolean acceptConduitData, boolean acceptConduitBuild, boolean acceptFinalize) {
            this.acceptNetworkData = acceptNetworkData;
            this.acceptNetworkBuild = acceptNetworkBuild;
            this.acceptConduitData = acceptConduitData;
            this.acceptConduitBuild = acceptConduitBuild;
            this.acceptFinalize = acceptFinalize;
        }
    }
}

