/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.infos;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.infos.InfoEntry;

public class RunningTimeEntry
extends InfoEntry {
    long time;

    public RunningTimeEntry() {
        this.register();
    }

    @Override
    public String getName() {
        return "Running Time";
    }

    @Override
    public void write(IWriteableBuffer buf) {
        buf.writeLong(this.getProcessor().getWorkTime());
    }

    @Override
    public void read(IReadableBuffer buf) {
        this.time = buf.readLong();
    }

    @Override
    public int currentValue() {
        return 0;
    }

    @Override
    public int maxValue() {
        return 0;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        int wid = width - 25;
        helper.renderText(x - wid, y, width, "Running Time: " + this.formatIntoTime(this.time));
    }

    String formatIntoTime(long time) {
        int sec = (int)(time /= 1000L) % 60;
        int min = (int)(time /= 60L) % 60;
        int hour = (int)(time /= 60L) % 24;
        return String.format("%02d:%02d:%02d:%02d", time /= 24L, hour, min, sec);
    }
}

