/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.entity.LivingEntityBaseBridge;
import org.spongepowered.mod.mixin.core.entity.EntityMixin_Forge;
import org.spongepowered.mod.util.StaticMixinForgeHelper;

@NonnullByDefault
@Mixin(value={EntityLivingBase.class}, priority=1001)
public abstract class EntityLivingBaseMixin_Forge
extends EntityMixin_Forge
implements LivingEntityBaseBridge {
    @Override
    public Optional<List<DamageFunction>> bridge$provideArmorModifiers(EntityLivingBase entityLivingBase, DamageSource source, double damage) {
        return StaticMixinForgeHelper.createArmorModifiers((EntityLivingBase)this, source, damage);
    }

    @Override
    public float bridge$applyModDamage(EntityLivingBase entityLivingBase, DamageSource source, float damage) {
        return ForgeHooks.onLivingHurt((EntityLivingBase)((EntityLivingBase)this), (DamageSource)source, (float)damage);
    }

    @Override
    public void bridge$applyArmorDamage(EntityLivingBase entityLivingBase, DamageSource source, DamageEntityEvent entityEvent, DamageModifier modifier) {
        Optional<ISpecialArmor.ArmorProperties> optional = modifier.getCause().getContext().get(StaticMixinForgeHelper.ARMOR_PROPERTY);
        if (optional.isPresent()) {
            StaticMixinForgeHelper.acceptArmorModifier((EntityLivingBase)this, source, modifier, entityEvent.getDamage(modifier));
        }
    }

    @Override
    public float bridge$applyModDamagePost(EntityLivingBase entityLivingBase, DamageSource source, float damage) {
        return ForgeHooks.onLivingDamage((EntityLivingBase)((EntityLivingBase)this), (DamageSource)source, (float)damage);
    }

    @Override
    public boolean bridge$hookModAttack(EntityLivingBase entityLivingBase, DamageSource source, float amount) {
        return ForgeHooks.onLivingAttack((EntityLivingBase)((EntityLivingBase)this), (DamageSource)source, (float)amount);
    }

    @Redirect(method={"updateActiveHand"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z"))
    private boolean forge$SkipForgeCheckOnServer(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K) {
            return true;
        }
        return stack.func_190926_b();
    }

    @Redirect(method={"setActiveHand"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/event/ForgeEventFactory;onItemUseStart(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;I)I", remap=false))
    private int forge$OnlyThrowForgeEventOnClient(EntityLivingBase this$0, ItemStack stack, int duration) {
        if (!this.field_70170_p.field_72995_K) {
            return duration;
        }
        return ForgeEventFactory.onItemUseStart((EntityLivingBase)this$0, (ItemStack)stack, (int)duration);
    }

    @Redirect(method={"onItemUseFinish"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/event/ForgeEventFactory;onItemUseFinish(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;ILnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", remap=false))
    private ItemStack forge$OnlyThrowForgeEventOnClient(EntityLivingBase entity, ItemStack item, int duration, ItemStack result) {
        if (!this.field_70170_p.field_72995_K) {
            return result;
        }
        return ForgeEventFactory.onItemUseFinish((EntityLivingBase)entity, (ItemStack)item, (int)duration, (ItemStack)result);
    }

    @Redirect(method={"stopActiveHand"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/event/ForgeEventFactory;onUseItemStop(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;I)Z", remap=false))
    private boolean forge$OnlyThrowForgeStopEventOnClient(EntityLivingBase entity, ItemStack item, int duration) {
        if (!this.field_70170_p.field_72995_K) {
            return false;
        }
        return ForgeEventFactory.onUseItemStop((EntityLivingBase)entity, (ItemStack)item, (int)duration);
    }
}

