/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.property.store.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.data.property.block.UnbreakableProperty;
import org.spongepowered.api.world.Location;
import org.spongepowered.common.data.property.store.common.AbstractBlockPropertyStore;
import org.spongepowered.common.util.VecHelper;

public class UnbreakablePropertyStore
extends AbstractBlockPropertyStore<UnbreakableProperty> {
    private static final UnbreakableProperty TRUE = new UnbreakableProperty(true);
    private static final UnbreakableProperty FALSE = new UnbreakableProperty(false);

    public UnbreakablePropertyStore() {
        super(false);
    }

    @Override
    protected Optional<UnbreakableProperty> getForBlock(@Nullable Location<?> location, IBlockState block) {
        BlockPos blockPos;
        if (location == null) {
            return Optional.empty();
        }
        World world = (World)location.getExtent();
        float blockHardness = block.func_185887_b(world, blockPos = VecHelper.toBlockPos(location));
        return Optional.of(blockHardness < 0.0f ? TRUE : FALSE);
    }

    @Override
    public Optional<UnbreakableProperty> getFor(Location<org.spongepowered.api.world.World> location) {
        World extent;
        IBlockState blockState = (IBlockState)location.getBlock();
        float hardness = blockState.func_185887_b(extent = (World)location.getExtent(), VecHelper.toBlockPos(location));
        return Optional.of(hardness < 0.0f ? TRUE : FALSE);
    }
}

