/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.immutable.ImmutableListData;
import org.spongepowered.api.data.manipulator.mutable.ListData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableListValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableSingleData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractImmutableListData<E, I extends ImmutableListData<E, I, M>, M extends ListData<E, M, I>>
extends AbstractImmutableSingleData<List<E>, I, M>
implements ImmutableListData<E, I, M> {
    private final Class<? extends M> mutable;
    private final ImmutableListValue<E> listValue;

    protected AbstractImmutableListData(Class<I> manipulatorClass, List<E> value, Key<? extends BaseValue<List<E>>> usedKey, Class<? extends M> mutableClass) {
        super(manipulatorClass, ImmutableList.copyOf(value), usedKey);
        Preconditions.checkArgument((!Modifier.isAbstract(mutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(mutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be an interface!");
        this.mutable = mutableClass;
        this.listValue = new ImmutableSpongeListValue(this.usedKey, ImmutableList.copyOf((Collection)((Collection)this.value)));
    }

    @Override
    protected final ImmutableListValue<E> getValueGetter() {
        return this.listValue;
    }

    @Override
    public List<E> getValue() {
        return ImmutableList.copyOf((Collection)((Collection)super.getValue()));
    }

    @Override
    public M asMutable() {
        return (M)((ListData)ReflectionUtil.createInstance(this.mutable, this.value));
    }

    @Override
    public ImmutableListValue<E> getListValue() {
        return this.getValueGetter();
    }

    @Override
    public List<E> asList() {
        return this.getValue();
    }
}

