/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.dispatcher.Disambiguator;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.command.SpongeCommandDispatcher;
import org.spongepowered.common.util.SpongeCommonTranslationHelper;

public class SpongeCommandDisambiguator
implements Disambiguator {
    private final Game game;

    public SpongeCommandDisambiguator(Game game) {
        this.game = game;
    }

    @Override
    @NonnullByDefault
    public Optional<CommandMapping> disambiguate(@Nullable CommandSource source, String aliasUsed, List<CommandMapping> availableOptions) {
        String chosenPlugin;
        if (availableOptions.size() > 1 && (chosenPlugin = SpongeImpl.getGlobalConfigAdapter().getConfig().getCommands().getAliases().get(aliasUsed.toLowerCase())) != null) {
            Optional<PluginContainer> container = this.game.getPluginManager().getPlugin(chosenPlugin);
            if (!container.isPresent()) {
                SpongeImpl.getGame().getServer().getConsole().sendMessage(SpongeCommonTranslationHelper.t("Unable to find plugin '" + chosenPlugin + "' for command '" + aliasUsed + "', falling back to default", new Object[0]));
            } else {
                Set<CommandMapping> ownedCommands = this.game.getCommandManager().getOwnedBy(container.get());
                ImmutableList ownedMatchingCommands = ImmutableList.copyOf((Iterable)Iterables.filter(availableOptions, (Predicate)Predicates.in(ownedCommands)));
                if (ownedMatchingCommands.isEmpty()) {
                    SpongeImpl.getGame().getServer().getConsole().sendMessage(SpongeCommonTranslationHelper.t("Plugin " + container.get().getName() + " was specified as the preferred owner for " + aliasUsed + ", but does not have any such command!", new Object[0]));
                } else {
                    if (ownedMatchingCommands.size() > 1) {
                        throw new IllegalStateException("Plugin " + container.get().getName() + " seems to have multiple commands registered as " + aliasUsed + "! This is a programming error!");
                    }
                    return Optional.of(ownedMatchingCommands.get(0));
                }
            }
        }
        return SpongeCommandDispatcher.FIRST_DISAMBIGUATOR.disambiguate(source, aliasUsed, availableOptions);
    }
}

